% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResampleResult_operators.R
\name{getRRPredictionList}
\alias{getRRPredictionList}
\title{Get list of predictions for train and test set of each single resample iteration.}
\usage{
getRRPredictionList(res, ...)
}
\arguments{
\item{res}{(\link{ResampleResult})\cr
The result of \link{resample} run with \code{keep.pred = TRUE}.}

\item{...}{(any)\cr
Further options passed to \link{makePrediction}.}
}
\value{
\link{list}.
}
\description{
This function creates a list with two slots \code{train} and \code{test} where
each slot is again a list of \link{Prediction} objects for each single
resample iteration.
In case that \code{predict = "train"} was used for the resample description
(see \link{makeResampleDesc}), the slot \code{test} will be \code{NULL}
and in case that \code{predict = "test"} was used, the slot \code{train} will be
\code{NULL}.
}
\seealso{
Other resample: \code{\link{ResamplePrediction}},
  \code{\link{ResampleResult}}, \code{\link{addRRMeasure}},
  \code{\link{getRRPredictions}},
  \code{\link{getRRTaskDescription}},
  \code{\link{getRRTaskDesc}},
  \code{\link{makeResampleDesc}},
  \code{\link{makeResampleInstance}},
  \code{\link{resample}}
}
