% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OverBaggingWrapper.R
\name{makeOverBaggingWrapper}
\alias{makeOverBaggingWrapper}
\title{Fuse learner with the bagging technique and oversampling for imbalancy correction.}
\usage{
makeOverBaggingWrapper(learner, obw.iters = 10L, obw.rate = 1,
  obw.maxcl = "boot", obw.cl = NULL)
}
\arguments{
\item{learner}{(\link{Learner} | \code{character(1)})\cr
The learner.
If you pass a string the learner will be created via \link{makeLearner}.}

\item{obw.iters}{(\code{integer(1)})\cr
Number of fitted models in bagging.
Default is 10.}

\item{obw.rate}{(\code{numeric(1)})\cr
Factor to upsample a class in each bag.
Must be between 1 and \code{Inf},
where 1 means no oversampling and 2 would mean doubling the class size.
Default is 1.}

\item{obw.maxcl}{(\code{character(1)})\cr
How should other class (usually larger class) be handled?
\dQuote{all} means every instance of the class gets in each bag,
\dQuote{boot} means the class instances are bootstrapped in each iteration.
Default is \dQuote{boot}.}

\item{obw.cl}{(\code{character(1)})\cr
Which class should be over- or undersampled. If \code{NULL}, \code{makeOverBaggingWrapper}
will take the smaller class.}
}
\value{
\link{Learner}.
}
\description{
Fuses a classification learner for binary classification with an over-bagging method
for imbalancy correction when we have strongly unequal class sizes.
Creates a learner object, which can be
used like any other learner object.
Models can easily be accessed via \link{getLearnerModel}.

OverBagging is implemented as follows:
For each iteration a random data subset is sampled. Class examples
are oversampled with replacement with a given rate.
Members of the other class are either simply copied into each bag, or bootstrapped with replacement
until we have as many majority class examples as in the original training data.
Features are currently not changed or sampled.

Prediction works as follows:
For classification we do majority voting to create a discrete label and
probabilities are predicted by considering the proportions of all predicted labels.
}
\seealso{
Other imbalancy: \code{\link{makeUndersampleWrapper}},
  \code{\link{oversample}}, \code{\link{smote}}

Other wrapper: \code{\link{makeBaggingWrapper}},
  \code{\link{makeClassificationViaRegressionWrapper}},
  \code{\link{makeConstantClassWrapper}},
  \code{\link{makeCostSensClassifWrapper}},
  \code{\link{makeCostSensRegrWrapper}},
  \code{\link{makeDownsampleWrapper}},
  \code{\link{makeDummyFeaturesWrapper}},
  \code{\link{makeExtractFDAFeatsWrapper}},
  \code{\link{makeFeatSelWrapper}},
  \code{\link{makeFilterWrapper}},
  \code{\link{makeImputeWrapper}},
  \code{\link{makeMulticlassWrapper}},
  \code{\link{makeMultilabelBinaryRelevanceWrapper}},
  \code{\link{makeMultilabelClassifierChainsWrapper}},
  \code{\link{makeMultilabelDBRWrapper}},
  \code{\link{makeMultilabelNestedStackingWrapper}},
  \code{\link{makeMultilabelStackingWrapper}},
  \code{\link{makePreprocWrapperCaret}},
  \code{\link{makePreprocWrapper}},
  \code{\link{makeRemoveConstantFeaturesWrapper}},
  \code{\link{makeSMOTEWrapper}},
  \code{\link{makeTuneWrapper}},
  \code{\link{makeUndersampleWrapper}},
  \code{\link{makeWeightedClassesWrapper}}
}
