% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMultilabelBinaryPerformances.R
\name{getMultilabelBinaryPerformances}
\alias{getMultilabelBinaryPerformances}
\title{Retrieve binary classification measures for multilabel classification predictions.}
\usage{
getMultilabelBinaryPerformances(pred, measures)
}
\arguments{
\item{pred}{(\link{Prediction})\cr
Multilabel Prediction object.}

\item{measures}{(\link{Measure} | list of \link{Measure})\cr
Performance measure(s) to evaluate, must be applicable to binary classification performance.
Default is \code{mmce}.}
}
\value{
(named \code{matrix}). Performance value(s), column names are measure(s), row names are labels.
}
\description{
Measures the quality of each binary label prediction w.r.t. some binary classification
performance measure.
}
\examples{
# see makeMultilabelBinaryRelevanceWrapper
}
\seealso{
Other multilabel: \code{\link{makeMultilabelBinaryRelevanceWrapper}},
  \code{\link{makeMultilabelClassifierChainsWrapper}},
  \code{\link{makeMultilabelDBRWrapper}},
  \code{\link{makeMultilabelNestedStackingWrapper}},
  \code{\link{makeMultilabelStackingWrapper}}
}
