% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OverUnderSampling.R
\name{oversample}
\alias{oversample}
\alias{undersample}
\title{Over- or undersample binary classification task to handle class imbalancy.}
\usage{
oversample(task, rate, cl = NULL)

undersample(task, rate, cl = NULL)
}
\arguments{
\item{task}{[\code{\link{Task}}]\cr
The task.}

\item{rate}{[\code{numeric(1)}]\cr
Factor to upsample or downsample a class.
For undersampling: Must be between 0 and 1,
where 1 means no downsampling, 0.5 implies reduction to 50 percent
and 0 would imply reduction to 0 observations.
For oversampling: Must be between 1 and \code{Inf},
where 1 means no oversampling and 2 would mean doubling the class size.}

\item{cl}{[\code{character(1)}]\cr
Which class should be over- or undersampled. If \code{NULL}, \code{oversample}
will select the smaller and \code{undersample} the larger class.}
}
\value{
[\code{\link{Task}}].
}
\description{
Oversampling: For a given class (usually the smaller one) all existing observations are
taken and copied and extra observations are added by randomly sampling with replacement from this class.

Undersampling: For a given class (usually the larger one) the number of observations is
reduced (downsampled) by randomly sampling without replacement from this class.
}
\seealso{
Other imbalancy: \code{\link{makeOverBaggingWrapper}},
  \code{\link{makeUndersampleWrapper}}, \code{\link{smote}}
}
