% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RLearner_regr_randomForestSRC.R,
%   R/getFeatureImportance.R
\name{getFeatureImportanceLearner.regr.randomForestSRC}
\alias{getFeatureImportanceLearner.regr.randomForestSRC}
\alias{getFeatureImportanceLearner}
\title{Calculates feature importance values for a given learner.}
\usage{
\method{getFeatureImportanceLearner}{regr.randomForestSRC}(.learner, .model,
  ...)

getFeatureImportanceLearner(.learner, .model, ...)
}
\arguments{
\item{.learner}{[\code{\link{Learner}} | \code{character(1)}]\cr
The learner.}

\item{.model}{[\code{\link{WrappedModel}}]\cr
The model.}

\item{...}{[any]\cr
Additional parameters, which are passed to the underlying importance value 
generating function.}
}
\value{
[\code{numeric}] A named vector of variable importance.
}
\description{
This function is mostly for internal usage. To calculate feature importance use \code{\link{getFeatureImportance}}.

The return value is a named numeric vector. There does not need to be one value for each feature in the dataset.
In \code{\link{getFeatureImportance}} missing features will get an importance of zero and if the vector contains \code{NA}
they will also be replaced with zero.
}
\keyword{internal}
