% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normUniImp.r
\name{normUniImp}
\alias{normUniImp}
\title{Normal regression imputation of a single variable}
\usage{
normUniImp(obsData, impFormula, M = 5, pd = FALSE)
}
\arguments{
\item{obsData}{The data frame to be imputed.}

\item{impFormula}{The linear model formula.}

\item{M}{Number of imputations to generate.}

\item{pd}{Specify whether to use posterior draws (\code{TRUE})
or not (\code{FALSE}).}
}
\value{
A list of imputed datasets, or if \code{M=1}, just the imputed data frame.
}
\description{
Performs multiple imputation of a single continuous variable using a normal
linear regression model. The covariates in the imputation model must be fully
observed. By default \code{normUniImp} imputes every dataset using the
maximum likelihood estimates of the imputation model parameters, which here
coincides with the OLS estimates, referred to as maximum likelihood multiple
imputation by von Hippel (2018). If \code{pd=TRUE} is specified, it instead
performs posterior draw Bayesian imputation.
}
\details{
Imputed datasets can be analysed using \code{\link{withinBetween}},
\code{\link{scoreBased}}, or for example the
\href{https://cran.r-project.org/package=bootImpute}{bootImpute} package.
}
\examples{
#simulate a dataset with one partially observed (conditionally) normal variable
set.seed(1234)
n <- 100
x <- rnorm(n)
y <- x+rnorm(n)
x[runif(n)<0.25] <- NA
temp <- data.frame(x=x,y=y)

#impute using normImp
imps <- normUniImp(temp, y~x, M=10, pd=FALSE)
}
\references{
von Hippel P.T. (2018) Maximum likelihood multiple imputation: faster,
more efficient imputation without posterior draws. \href{https://arxiv.org/abs/1210.0870v9}{arXiv:1210.0870v9}.
}
