% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hausman.R
\name{hausman}
\alias{hausman}
\title{Hausman Test (experimental)}
\usage{
hausman(re_model)
}
\arguments{
\item{re_model}{model produced using the \code{lme4::lmer()} function. This is an object of class \code{merMod} and subclass \code{lmerMod}.}
}
\value{
an object of class "htest"
}
\description{
The Hausman test tests whether there are significant differences between fixed effect and random effect models with similar specifications. If there is a significant difference, a random effects models (i.e. a multilevel model) \emph{may} be more suitable (efficient). This function takes a model estimated with \code{lme4::lmer}, automatically re-estimates a fixed effects model, applies the Hausman test, and returns the test statistic and p-value.

The Hausman test is based on (Fox, 2016, p. 732, footnote 46). The Hausman test statistic is distributed as chi-square with degrees of freedom equal to the number of coefficients.

\strong{Note}: The selection of a mixed effect (random effect/multilevel) model should not be solely driven by the Hausman test or any other single statistic. Proper model selection should reflect the research questions and nested nature of the data. In addition, Fox suggests that "the choice between random and fixed effects should reflect our view of the process that generates the data" (p. 732). See also https://stats.stackexchange.com/questions/502811/should-a-hausman-test-be-used-to-decide-between-fixed-vs-random-effects for a discussion of the test and its results.
}
\examples{
fit <- lme4::lmer(mathach ~ 1 + ses + catholic + (1|id),
data=hsb, REML=TRUE)

hausman(fit)

}
\references{
{
\insertRef{fox2016}{mlmhelpr}
}
}
