% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracking-client.R
\name{mlflow_client_list_experiments}
\alias{mlflow_client_list_experiments}
\title{List Experiments}
\usage{
mlflow_client_list_experiments(client, view_type = c("ACTIVE_ONLY",
  "DELETED_ONLY", "ALL"))
}
\arguments{
\item{client}{An `mlflow_client` object.}

\item{view_type}{Qualifier for type of experiments to be returned. Defaults to `ACTIVE_ONLY`.}
}
\description{
Get a list of all experiments.
}
\details{
The Tracking Client family of functions require an MLflow client to be
  specified explicitly. These functions allow for greater control of where the
  operations take place in terms of services and runs, but are more verbose
  compared to the Fluent API.
}
\seealso{
Other Tracking client functions: \code{\link{mlflow_client_create_experiment}},
  \code{\link{mlflow_client_create_run}},
  \code{\link{mlflow_client_delete_experiment}},
  \code{\link{mlflow_client_delete_run}},
  \code{\link{mlflow_client_download_artifacts}},
  \code{\link{mlflow_client_get_experiment_by_name}},
  \code{\link{mlflow_client_get_experiment}},
  \code{\link{mlflow_client_get_run}},
  \code{\link{mlflow_client_list_artifacts}},
  \code{\link{mlflow_client_log_artifact}},
  \code{\link{mlflow_client_log_metric}},
  \code{\link{mlflow_client_log_param}},
  \code{\link{mlflow_client_restore_experiment}},
  \code{\link{mlflow_client_restore_run}},
  \code{\link{mlflow_client_set_tag}},
  \code{\link{mlflow_client_set_terminated}}
}
\concept{Tracking client functions}
\keyword{internal}
