% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partitions_iter.R
\name{iterative.stratification.partitions}
\alias{iterative.stratification.partitions}
\title{Generic partitioning of an mldr object}
\usage{
iterative.stratification.partitions(mld, is.cv = FALSE, r, seed = 10,
  get.indices = FALSE)
}
\arguments{
\item{mld}{The \code{mldr} object to be partitioned}

\item{is.cv}{Option to enable treatment of partitions as cross-validation test folds}

\item{r}{A vector of percentages of instances to be selected for each partition}

\item{seed}{The seed to initialize the random number generator. By default is 10. Change it if you want to obtain partitions containing
different samples, for instance to use a 2x5 fcv strategy}

\item{get.indices}{A logical value indicating whether to return lists of indices or lists of \code{"mldr"} objects}
}
\value{
An \code{mldr.folds} object. This is a list containing k elements, one for each fold. Each element is made up
of two mldr objects, called \code{train} and \code{test}
}
\description{
Iterative stratification

Implemented from the algorithm explained in:
  Konstantinos Sechidis, Grigorios Tsoumakas, and Ioannis Vlahavas. 2011.
  On the stratification of multi-label data. In Proceedings of the 2011
  European conference on Machine learning and knowledge discovery in
  databases - Volume Part III (ECML PKDD'11), Dimitrios Gunopulos,
  Thomas Hofmann, Donato Malerba, and Michalis Vazirgiannis (Eds.), Vol.
  Part III. Springer-Verlag, Berlin, Heidelberg, 145-158.
}
\examples{
\dontrun{
library(mldr.datasets)
library(mldr)
parts.emotions <- iterative.stratification.partitions(emotions, r = c(35, 25, 40))
summary(parts.emotions[[2]])
}
}
