% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manipulate_species.R
\name{removeSpecies}
\alias{removeSpecies}
\title{Remove species}
\usage{
removeSpecies(params, species)
}
\arguments{
\item{params}{A mizer params object for the original system.}

\item{species}{The species to be removed. A vector of species names, or a
numeric vector of species indices, or a logical vector indicating for
each species whether it is to be removed (TRUE) or not.}
}
\value{
An object of type \linkS4class{MizerParams}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function simply removes all entries from the MizerParams object that
refer to the selected species. It does not recalculate the steady state for
the remaining species or retune their reproductive efficiency.
}
\examples{
\dontrun{
params <- NS_params
species_params(params)$species
params <- removeSpecies(params, c("Cod", "Haddock"))
species_params(params)$species
}
}
