% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_methods.R
\name{mizerRDI}
\alias{mizerRDI}
\title{Get density-independent rate of reproduction needed to project standard
mizer model}
\usage{
mizerRDI(params, n, n_pp, n_other, t, e_growth, mort, e_repro, ...)
}
\arguments{
\item{params}{A \linkS4class{MizerParams} object}

\item{n}{A matrix of species abundances (species x size).}

\item{n_pp}{A vector of the resource abundance by size}

\item{n_other}{A list of abundances for other dynamical components of the
ecosystem}

\item{t}{The time for which to do the calculation (Not used by standard
mizer rate functions but useful for extensions with time-dependent
parameters.)}

\item{e_growth}{An array (species x size) with the energy available for
growth as calculated by \code{\link[=getEGrowth]{getEGrowth()}}. Unused.}

\item{mort}{An array (species x size) with the mortality rate as calculated
by \code{\link[=getMort]{getMort()}}. Unused.}

\item{e_repro}{An array (species x size) with the energy available for
reproduction as calculated by \code{\link[=getERepro]{getERepro()}}.}

\item{...}{Unused}
}
\value{
A numeric vector with the rate of egg production for each species.
}
\description{
Calculates the density-independent rate of total egg production
\eqn{R_{di}}{R_di} (units 1/year) before density dependence, by species.
You would not usually call this
function directly but instead use \code{\link[=getRDI]{getRDI()}}, which then calls this
function unless an alternative function has been registered, see below.
}
\details{
This rate is obtained by taking the per capita rate \eqn{E_r(w)\psi(w)} at
which energy is invested in reproduction, as calculated by \code{\link[=getERepro]{getERepro()}},
multiplying it by the number of individuals\eqn{N(w)} and integrating over all sizes
\eqn{w} and then multiplying by the reproductive efficiency \eqn{\epsilon}
and dividing by the egg size \code{w_min}, and by a factor of two to account for
the two sexes:
\deqn{R_{di} = \frac{\epsilon}{2 w_{min}} \int N(w)  E_r(w) \psi(w) \, dw}{R_di = (\epsilon/(2 w_min)) \int N(w)  E_r(w) \psi(w) dw}

Used by \code{\link[=getRDD]{getRDD()}} to calculate the actual, density dependent rate.
See \code{\link[=setReproduction]{setReproduction()}} for more details.
}
\section{Your own reproduction function}{

By default \code{\link[=getRDI]{getRDI()}} calls \code{\link[=mizerRDI]{mizerRDI()}}. However you can
replace this with your own alternative reproduction function. If
your function is called \code{"myRDI"} then you register it in a MizerParams
object \code{params} with\preformatted{params <- setRateFunction(params, "RDI", "myRDI")
}

Your function will then be called instead of \code{\link[=mizerRDI]{mizerRDI()}}, with the
same arguments.
}

\seealso{
Other mizer rate functions: 
\code{\link{mizerEGrowth}()},
\code{\link{mizerEReproAndGrowth}()},
\code{\link{mizerERepro}()},
\code{\link{mizerEncounter}()},
\code{\link{mizerFMortGear}()},
\code{\link{mizerFMort}()},
\code{\link{mizerFeedingLevel}()},
\code{\link{mizerMort}()},
\code{\link{mizerPredMort}()},
\code{\link{mizerPredRate}()},
\code{\link{mizerRates}()},
\code{\link{mizerResourceMort}()}
}
\concept{mizer rate functions}
