% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setExtMort.R
\name{setExtMort}
\alias{setExtMort}
\alias{getExtMort}
\title{Set external mortality rate}
\usage{
setExtMort(params, z0 = NULL, z0pre = 0.6, z0exp = -1/4, ...)

getExtMort(params)
}
\arguments{
\item{params}{MizerParams}

\item{z0}{Optional. An array (species x size) holding the external
mortality rate.}

\item{z0pre}{If \code{z0}, the mortality from other sources, is not a column
in the species data frame, it is calculated as z0pre * w_inf ^ z0exp.
Default value is 0.6.}

\item{z0exp}{If \code{z0}, the mortality from other sources, is not a column
in the species data frame, it is calculated as \code{z0pre * w_inf ^ z0exp}.
Default value is \code{n-1}.}

\item{...}{Unused}
}
\value{
MizerParams object with updated external mortality rate. Because of
the way the R language works, \code{setExtMort()} does not make the changes
to the params object that you pass to it but instead returns a new params
object. So to affect the change you call the function in the form
\code{params <- setExtMort(params, ...)}.
}
\description{
Set external mortality rate
}
\section{Setting external mortality rate}{

The external mortality is all the mortality that is not due to fishing or
predation by predators included in the model. The external mortality could be
due to predation by predators that are not explicitly included in the model
(e.g. mammals or seabirds) or due to other causes like illness. It is a rate
with units 1/year.

The \code{z0} argument allows you to specify an external mortality rate
that depends on species and body size. You can see an example of this in
the Examples section of the help page for \code{\link[=setExtMort]{setExtMort()}}.

If the \code{z0} argument is not supplied, then the external mortality
is assumed to depend only on the species, not on the
size of the individual: \eqn{\mu_{b.i}(w) = z_{0.i}}. The value of the
constant \eqn{z_0} for each species is taken from the \code{z0} column of the
species_params data frame, if that column exists. Otherwise it is calculated
as
\deqn{z_{0.i} = {\tt z0pre}_i\, w_{inf}^{\tt z0exp}.}{z_{0.i} = z0pre_i w_{inf}^{z0exp}.}
}

\examples{
\dontrun{
params <- newMultispeciesParams(NS_species_params)

#### Setting allometric death rate #######################

# Set coefficient for each species. Here we choose 0.1 for each species
z0pre <- rep(0.1, nrow(params@species_params))

# Multiply by power of size with exponent, here chosen to be -1/4
# The outer() function makes it an array species x size
z0 <- outer(z0pre, params@w^(-1/4))

# Change the external mortality rate in the params object
params <- setExtMort(params, z0 = z0)
}
}
\seealso{
Other functions for setting parameters: 
\code{\link{setFishing}()},
\code{\link{setInitialValues}()},
\code{\link{setInteraction}()},
\code{\link{setMaxIntakeRate}()},
\code{\link{setMetabolicRate}()},
\code{\link{setPredKernel}()},
\code{\link{setReproduction}()},
\code{\link{setResource}()},
\code{\link{setSearchVolume}()},
\code{\link{species_params}()}
}
\concept{functions for setting parameters}
