% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_methods.R
\name{mizerEncounter}
\alias{mizerEncounter}
\title{Get encounter rate needed to project standard mizer model}
\usage{
mizerEncounter(params, n, n_pp, n_other, ...)
}
\arguments{
\item{params}{A \linkS4class{MizerParams} object}

\item{n}{A matrix of species abundances (species x size).}

\item{n_pp}{A vector of the resource abundance by size}

\item{n_other}{A list of abundances for other dynamical components of the
ecosystem}

\item{...}{Unused}
}
\value{
A two dimensional array (predator species x predator size) with the
encounter rates.
}
\description{
Calculates the rate \eqn{E_i(w)} at which a predator of species \eqn{i} and
weight \eqn{w} encounters food (grams/year).
}
\section{Predation encounter}{

The encounter rate \eqn{E_i(w)} at which a predator of species \eqn{i}
and weight \eqn{w} encounters food has contributions from the encounter of
fish prey and of resource. This is determined by summing over all prey
species and the resource spectrum and then integrating over all prey sizes
\eqn{w_p}, weighted by predation kernel \eqn{\phi(w,w_p)}:
\deqn{
E_i(w) = \gamma_i(w) \int 
\left( \theta_{ip} N_R(w_p) + \sum_{j} \theta_{ij} N_j(w_p) \right) 
\phi_i(w,w_p) w_p \, dw_p.
}{\gamma_i(w) \int 
( \theta_{ip} N_R(w_p) + \sum_{j} \theta_{ij} N_j(w_p) ) 
\phi_i(w,w_p) w_p dw_p.}
Here \eqn{N_j(w)} is the abundance density of species \eqn{j} and
\eqn{N_R(w)} is the abundance density of resource.
The overall prefactor \eqn{\gamma_i(w)} determines the predation power of the
predator. It could be interpreted as a search volume and is set with the
\code{\link[=setSearchVolume]{setSearchVolume()}} function. The predation kernel
\eqn{\phi(w,w_p)} is set with the \code{\link[=setPredKernel]{setPredKernel()}} function. The
species interaction matrix \eqn{\theta_{ij}} is set with \code{\link[=setInteraction]{setInteraction()}}
and the resource interaction vector \eqn{\theta_{ip}} is taken from the
\code{interaction_resource} column in \code{params@species_params}.
}

\section{Details}{

The encounter rate is multiplied by \eqn{1-f_0} to obtain the consumption rate,
where \eqn{f_0} is the feeding level calculated with \code{\link[=getFeedingLevel]{getFeedingLevel()}}.
This is used by the \code{\link[=project]{project()}} function for performing simulations.

The function returns values also for sizes outside the size-range of the
species. These values should not be used, as they are meaningless.
}

\seealso{
Other mizer rate functions: 
\code{\link{mizerEGrowth}()},
\code{\link{mizerEReproAndGrowth}()},
\code{\link{mizerERepro}()},
\code{\link{mizerFMortGear}()},
\code{\link{mizerFMort}()},
\code{\link{mizerFeedingLevel}()},
\code{\link{mizerMort}()},
\code{\link{mizerPredMort}()},
\code{\link{mizerPredRate}()},
\code{\link{mizerRDI}()},
\code{\link{mizerRates}()},
\code{\link{mizerResourceMort}()}
}
\concept{mizer rate functions}
