% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\docType{methods}
\name{plotM2}
\alias{plotM2}
\alias{plotM2,MizerSim-method}
\title{Plot M2 of each species by size}
\usage{
plotM2(object, ...)

\S4method{plotM2}{MizerSim}(object,
  time_range = max(as.numeric(dimnames(object@n)$time)), print_it = TRUE,
  ...)
}
\arguments{
\item{object}{An object of class \code{MizerSim}}

\item{...}{Other arguments to pass to \code{getM2} method.}

\item{time_range}{The time range (either a vector of values, a vector of min
and max time, or a single value) to average the abundances over. Default is
the final time step.}

\item{print_it}{Display the plot, or just return the ggplot2 object}
}
\value{
A ggplot2 object
}
\description{
After running a projection, plot M2 of each species by size. M2 is averaged
over the specified time range (a single value for the time range can be used
to plot a single time step).

Plot M2 using a \code{MizerSim} object.
}
\examples{
\dontrun{
data(NS_species_params_gears)
data(inter)
params <- MizerParams(NS_species_params_gears, inter)
sim <- project(params, effort=1, t_max=20, t_save = 2)
plotM2(sim)
plotM2(sim, time_range = 10:20)
}
}
\seealso{
\code{\link{getM2}}

\code{\link{getM2}}
}
