% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihoodNormal.R
\name{likelihoodNormalestimfix}
\alias{likelihoodNormalestimfix}
\title{Likelihood Function When The Fixed Effect Is Estimated}
\usage{
likelihoodNormalestimfix(mu1, mu2, omega, U, V, estimphi, random)
}
\arguments{
\item{mu1}{current value of the mean of the first effect}

\item{mu2}{current value of the mean of the second effect}

\item{omega}{current value of the standard deviation of the normal distribution}

\item{U}{vector of the M sufficient statistics U (see \code{\link{UV}})}

\item{V}{vector of the M sufficient statistics V (see \code{\link{UV}})}

\item{estimphi}{vector or matrix of estimators of the random effects}

\item{random}{random effects in the drift: 1 if one additive random effect, 2 if one multiplicative random effect or c(1,2) if 2 random effects.}
}
\value{
\item{L}{value of -2 x loglikelihood}
}
\description{
Computation of -2 loglikelihood of the mixed SDE with Normal distribution of the random effects when the fixed effect is estimated for random 1 or 2
 \eqn{dXj(t)= (\alpha_j- \beta_j Xj(t))dt + \sigma a(Xj(t)) dWj(t)}.
}
\references{
Maximum likelihood estimation for stochastic differential equations with random effects, M. Delattre, V. Genon-Catalot and A. Samson, \emph{Scandinavian Journal of Statistics 2012}, Vol 40, \bold{322--343}
}
