% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gammapar.R
\name{to_shape_rate_gamma}
\alias{to_shape_rate_gamma}
\title{Parameter Conversion for Gamma Distribution}
\usage{
to_shape_rate_gamma(mu, sd)
}
\arguments{
\item{mu}{a numeric vector representing the means of gamma distributions}

\item{sd}{a numeric vector representing the standard deviations of gamma distributions.
\code{mu} and \code{sd} should have the same length.}
}
\value{
a list of two items
\item{alpha}{a vector of the shapes of gamma distributions}
\item{lambda}{a vector of the rates of gamma distributions}
}
\description{
The function \code{to_shape_rate_gamma} converts the mean and standard deviation to the shape and rate
}
\details{
The purpose of this function is to convert the parameterization of gamma distribution in the form of
mean and standard deviation to the form of shape and rate. It can be used for specifying the initial
values for the EM algorithm when the first-hand initial values are in the form of mean and standard
deviation from K-means clustering algorithm.
}
\examples{
to_shape_rate_gamma(2, 1)
to_shape_rate_gamma(c(2, 4), c(1, 1))

}
\seealso{
\code{\link{to_mu_sd_gamma}}
}
