% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin.R
\name{bin}
\alias{bin}
\title{Binning the Raw Data}
\usage{
bin(x, brks)
}
\arguments{
\item{x}{a numeric vector}

\item{brks}{a numeric vector in increasing order, representing the value of each bin}
}
\value{
The function \code{bin} returns a matrix with three columns, representing the value of the left bin, the value of the right bin and the number of observations in \code{x} that falls in each bin.
}
\description{
This function creates a binned data from a numeric vector
}
\details{
Given a numeric vector, the function \code{bin} creates binned data with bin value provided
by \code{brks}. Fitting mixture models with a large dataset may be slow, especially when
we want to fit a mixture model outside of normal family. Binning the data with a relatively
small binwidth speeds up the computation of EM algorithm while at the same time keeps the
precision of the estimation result.
}
\examples{
set.seed(99)
x <- rmixnormal(200, c(0.5, 0.5), c(2, 5), c(1, 1))
data <- bin(x, seq(-2, 10, 0.1))
fit1 <- mixfit(x, ncomp = 2)
fit2 <- mixfit(data, ncomp = 2)

}
\seealso{
\code{\link{reinstate}}
}
