% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AlleleShare_Table.R
\name{AlleleShare_Table}
\alias{AlleleShare_Table}
\title{Calculate numbers of sharing alleles each pair at each locus}
\usage{
AlleleShare_Table(x,replicate=TRUE)
}
\arguments{
\item{x}{a dataset of alleles. Each row denotes each individual.One allele in one cell.In the (2r-1)th column, there is the same locus with the 2r-th column; noted: no column for ID, make row.names=1 when importing.}

\item{replicate}{a logical variable. if replicate is TRUE, the pairs are formed with replicates; if FALSE, the pairs are formed without replicate.}
}
\value{
y a matrix of numbers of shared alleles. Each row denotes each pair; Each column denotes each locus.
}
\description{
Calculate numbers of sharing alleles each pair at each locus
}
\details{
This function calculates the numbers of shared alleles between each pair of individuals for a dataset.Output a table and Usually followed by write.csv(as.data.frame(y),file = "~/*.csv") to export the results.
}
\examples{
x <- data.frame(STR1=c(12,13,13,14,15,13,14,12,14,15),
               STR1_1=c(12,14,13,15,13,14,13,12,14,15),
               SNP1=c("A","T","A","A","T","A","A","T","T","A"),
               SNP1_1=c("A","T","T","T","A","T","A","A","T","T"))
AlleleShare_Table(x,replicate=TRUE)

}
