% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.coef.R
\name{print.coef}
\alias{print.coef}
\title{Print coef object}
\usage{
\method{print}{coef}(x, print = x$args$print, digits = x$args$digits, check = TRUE, ...)
}
\arguments{
\item{x}{\code{coef} object.}

\item{print}{a character vector indicating which results to show, i.e. \code{"all"}, for all results
\code{"alpha"} for the coefficient alpha or \code{omega} for the coefficient omega,
and \code{"item"} for item statistics.}

\item{digits}{an integer value indicating the number of decimal places to be used for displaying
coefficient alpha or coefficient omega and item-total correlations or standardized
factor loadings.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
This function prints the \code{coef} object
}
\examples{
dat <- data.frame(item1 = c(5, 2, 3, 4, 1, 2, 4, 2),
                  item2 = c(5, 1, 3, 5, 2, 2, 5, 1),
                  item3 = c(4, 2, 4, 5, 1, 3, 5, 1),
                  item4 = c(5, 1, 2, 5, 2, 3, 4, 2), stringsAsFactors = FALSE)

#--------------------------------------
# Coefficient Alpha

# Compute unstandardized coefficient alpha and item statistics
dat.alpha <- alpha.coef(dat, output = FALSE)

# Print alpha.coef object to show unstandardized coefficient alpha and item statistics with 3 digits
print(dat.alpha, digits = 3)

# Print alpha.coef object to show unstandardized coefficient with 3 digits
print(dat.alpha, print = "alpha", digits = 3)

# Print alpha.coef object to show item statistics with 3 digits
print(dat.alpha, print = "item", digits = 3)

#--------------------------------------
# Coefficient Omega

# Compute unstandardized coefficient omega and item statistics
dat.omega <- omega.coef(dat, output = FALSE)

# Print omega.coef object to show unstandardized coefficient omega and item statistics with 3 digits
print(dat.omega, digits = 3)

# Print omega.coef object to show unstandardized coefficient with 3 digits
print(dat.omega, print = "omega", digits = 3)

# Print omega.coef object to show item statistics with 3 digits
print(dat.omega, print = "item", digits = 3)
}
\seealso{
\code{\link{alpha.coef}}, \code{\link{omega.coef}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
