% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcar.R
\name{mcar}
\alias{mcar}
\title{Little's missing completely at random (MCAR) test}
\usage{
mcar(data, debug = FALSE)
}
\arguments{
\item{data}{A data frame.}

\item{debug}{A logical value used only for unit testing.}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}}:
\item{statistic}{The d^2 statistic}
\item{degrees_freedom}{Degrees of freedom of chi-squared distribution}
\item{p_val}{P-value of the test}
\item{missing_patterns}{Number of missing patterns}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
\code{mcar()} performs Little's MCAR test to test for MCAR.
The null hypothesis is that the data is MCAR.
}
\details{
This function reproduces the d^2 statistic in equation (5) from [1].
This statistic is used to test for MCAR. Comments reference variables
from \code{vignette("background")} (in brackets) to improve readability and
traceability.
}
\note{
Code is adapted from \code{mcar_test()} from the naniar package
using base R instead of the tidyverse.
}
\examples{
mcar(pollutionlevels)

}
\references{
[1] Little RJA. A Test of Missing Completely at Random for
Multivariate Data with Missing Values. Journal of the
American Statistical Association. 1988;83(404):1198-202.
}
