% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/library.R
\name{md.simparams}
\alias{md.simparams}
\title{md.simparams}
\usage{
md.simparams()
}
\description{
Constructs an md.simparams object that holds the parameters required to generate the simulated data set. 
The parameters specifying covariates and event time variables are appended to the md.simparams by 
adding the appropriate function call
}
\examples{

\dontrun{
library(missDeaths)

sim = md.simparams() +
   md.sex("sex", 0.5) + 
   md.uniform("birth", as.Date("1930-1-1"), as.Date("1960-1-1")) +
   md.uniform("start", as.Date("2005-1-1"), as.Date("2010-1-1")) +
   md.death("death", survexp.us, "sex", "birth", "start") 
}

}
\seealso{
\code{\link{md.constant}}, \code{\link{md.uniform}}, \code{\link{md.binom}}, \code{\link{md.norm}}, \code{\link{md.mvnorm}}, \code{\link{md.sex}}, \code{\link{md.exp}}, \code{\link{md.death}}
}
