% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ListExperimentFunctions.R
\name{predict.listExperiment}
\alias{predict.listExperiment}
\title{Predict method for the list experiment}
\usage{
\method{predict}{listExperiment}(object, newdata = NULL,
  treatment.misreport = 0, par.control = NULL, par.sensitive = NULL,
  par.misreport = NULL, ...)
}
\arguments{
\item{object}{Object of class "listExperiment"}

\item{newdata}{An optional data frame from which to calculate predictions.}

\item{treatment.misreport}{Value of the treatment variable covariate in the misreport sub-model (if included in the model).
\describe{
    \item{0}{treatment indicator in the misreport sub-model is set to 0 for all individuals (default).}
    \item{1}{treatment indicator in the misreport sub-model is set to 1 for all individuals.}
    \item{"observed"}{treatment indicator in the misreport sub-model is set to the observed treatment value.}
}}

\item{par.control}{An optional set of control-items sub-model parameters to use in place of those from the fitted model.}

\item{par.sensitive}{An optional set of sensitive-item sub-model parameters to use in place of those from the fitted model.}

\item{par.misreport}{An optional set of misreport sub-model parameters to use in place of those from the fitted model.}

\item{...}{Additional arguments}
}
\description{
Obtains predictions from a fitted list experiment model of the class \code{listExperiment}.
}
\details{
If \code{newdata} is omitted, predictions will be made with
the data used for model fitting.
}
\section{Slots}{

\describe{
\item{\code{z.hat}}{Predicted probability of answering affirmatively to the sensitive item in the list experiment.}

\item{\code{u.hat}}{Predicted probability of misreporting (assuming respondent holds the sensitive belief).}
}}
\examples{

data(gender)

\dontrun{
# Note: substantial computation time
model.gender <- listExperiment(y ~ gender + ageGroup + education +
                                       motherTongue + region + selfPlacement,
                                   data = gender, J = 4,
                                   treatment = "treatment", direct = "direct",
                                   control.constraint = "none",
                                   sensitive.response = 0,
                                   misreport.treatment = TRUE)
predict(model.gender, treatment.misreport = 0)
}

}
\references{
Eady, Gregory. 2017 "The Statistical Analysis of Misreporting on Sensitive Survey Questions."
}

