% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vtrack.R
\name{gvtrack.array.slice}
\alias{gvtrack.array.slice}
\title{Defines rules for a single value calculation of a virtual 'Array' track}
\usage{
gvtrack.array.slice(vtrack = NULL, slice = NULL, func = "avg", params = NULL)
}
\arguments{
\item{vtrack}{virtual track name}

\item{slice}{a vector of column names or column indices or 'NULL'}

\item{func, params}{see below}
}
\value{
None.
}
\description{
Defines how a single value within an interval is achieved for a virtual
track based on 'Array' track.
}
\details{
A track (regular or virtual) used in a track expression is expected to
return one value for each track interval. 'Array' tracks store multiple
values per interval (one for each 'column') and hence if used in a track
expression one must define the way of how a single value should be deduced
from several ones.

By default if an 'Array' track is used in a track expressions, its interval
value would be the average of all column values that are not NaN.
'gvtrack.array.slice' allows to select specific columns and to specify the
function applied to their values.

'slice' parameter allows to choose the columns. Columns can be indicated by
their names or their indices. If 'slice' is 'NULL' the non-NaN values of all
track columns are used.

'func' parameter determines the function applied to the columns' values. Use
the following table for a reference of all valid functions and parameters
combinations:

\emph{func = "avg", params = NULL} \cr Average of columns' values.

\emph{func = "max", params = NULL} \cr Maximum of columns' values.

\emph{func = "min", params = NULL} \cr Minimum of columns' values.

\emph{func = "stdev", params = NULL} \cr Unbiased standard deviation of
columns' values.

\emph{func = "sum", params = NULL} \cr Sum of columns' values.

\emph{func = "quantile", params = [Percentile in the range of [0, 1]]} \cr
Quantile of columns' values.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()
gvtrack.create("vtrack1", "array_track")
gvtrack.array.slice("vtrack1", c("col2", "col4"), "max")
gextract("vtrack1", gintervals(1, 0, 1000))

}
\seealso{
\code{\link{gvtrack.create}},
\code{\link{gtrack.array.get_colnames}}, \code{\link{gtrack.array.extract}}
}
\keyword{~array}
\keyword{~virtual}
