% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirt-package.R
\docType{data}
\name{SLF}
\alias{SLF}
\title{Social Life Feelings Data}
\description{
A 5-item data set analyzed by Bartholomew (1998). Data contains
dichotomous responses (endorsement vs non-endorsement) from 1490 German
respondents to five statements on perceptions of social life.
}
\examples{

\dontrun{
# tabular format
data(SLF)
SLF

# full dataset
full <- expand.table(SLF)
itemstats(full)

mod <- mirt(full)
plot(mod, type = 'trace')

}
}
\references{
Bartholomew, D., J. (1998). Scaling unobservable constructs in social science. Journal of the Royal
Statistical Society - Series C, 47, 1-13.
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\keyword{data}
