% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirai.R
\name{call_mirai}
\alias{call_mirai}
\title{mirai (Call Value)}
\usage{
call_mirai(aio)
}
\arguments{
\item{aio}{a 'mirai' object.}
}
\value{
The passed mirai (invisibly). The retrieved value is stored at \code{$data}.
}
\description{
Call the value of a mirai, waiting for the the asynchronous operation to
    resolve if it is still in progress.
}
\details{
This function will wait for the async operation to complete if still
    in progress (blocking).

    A blocking call can be sent a user interrupt with e.g. ctrl+c. If the
    ongoing execution in the mirai is interruptible, it will resolve into
    an object of class 'miraiInterrupt' and 'errorValue'.
    \code{\link{is_mirai_interrupt}} may be used to handle such cases.

    If an error occurs in evaluation, the error message is returned as a
    character string of class 'miraiError' and 'errorValue'.
    \code{\link{is_mirai_error}} may be used to test for this.

    \code{\link{is_error_value}} tests for all error conditions including
    mirai errors, interrupts, and timeouts.

    The mirai updates itself in place, so to access the value of a mirai
    \code{x} directly, use \code{call_mirai(x)$data}.
}
\section{Alternatively}{


    The value of a mirai may be accessed at any time at \code{$data}, and
    if yet to resolve, an 'unresolved' logical NA will be returned instead.

    Using \code{\link{unresolved}} on a mirai returns TRUE only if a mirai
    has yet to resolve and FALSE otherwise. This is suitable for use in
    control flow statements such as \code{while} or \code{if}.
}

\examples{
if (interactive()) {
# Only run examples in interactive R sessions

m <- mirai(x + y + 1, x = 2, y = 3)
m
m$data
Sys.sleep(0.2)
m$data

df1 <- data.frame(a = 1, b = 2)
df2 <- data.frame(a = 3, b = 1)
m <- mirai(as.matrix(rbind(df1, df2)), .args = list(df1, df2), .timeout = 1000)
call_mirai(m)$data

m <- mirai({
  res <- rnorm(n)
  res / rev(res)
}, n = 1e6)
while (unresolved(m)) {
  cat("unresolved\n")
  Sys.sleep(0.1)
}
str(m$data)

file <- tempfile()
cat("r <- rnorm(n)", file = file)
n <- 10L
m <- mirai({source(file, local = TRUE); r}, .args = list(file, n))
call_mirai(m)[["data"]]
unlink(file)

}

}
