\name{summary.mipfp}
\alias{summary.mipfp}
\alias{print.summary.mipfp}
\title{
Summarizing objects of class mipfp
}
\description{
Summary method for class \code{mipfp}.
}
\usage{
\method{summary}{mipfp}(object, cov.method = "delta", prop = FALSE, 
        target.list = NULL, l.names = 0, ...)

\method{print}{summary.mipfp}(x, ...)
}
\arguments{
  \item{object}{
    An object of class \code{mipfp}, usually a result of a call to
    \link[mipfp:Estimate]{Estimate}
}
  \item{x}{
    An object of class \code{summary.mipfp}, usually a result of a call to
    \code{summary.mipfp}.
}
  \item{cov.method}{
    Indicates which method to use to compute the covariance. Possible values 
    are Delta (\code{delta}, default) or Lang (\code{lang}).
}
  \item{prop}{
    If set to \code{FALSE} (the default), the results return counts, 
    probabilities otherwise.
}
  \item{target.list}{
    The list of the dimensions of the targets used by for the estimation
    process (see \link[mipfp:Estimate]{Estimate} for more details).
}
  \item{l.names}{
    If set to a value greater than 0, then the names of the
    categories will be shorten to a length of \code{l.names} characters.
}
  \item{\dots}{
    Further arguments passed to the underlying \code{print} and \code{flat} 
    method, or from other methods.
}
}
\details{
The function \code{summary.mipfp} compute and returns a list of summary
statistics of the estimates (covariance, t-statistics, goodness-of-fit
statistics, associated degrees of freedom).
}
\value{
The function \code{summary.mipfp} returns an object of class 
\code{summary.mipfp} having the following components:
  \item{call}{
    A \code{call} object in which all the specified arguments are given by
    their full names.
}
  \item{conv}{
     A Boolean indicating if the specified method converged to a 
     solution (\code{TRUE}) or not (\code{FALSE}).
}
  \item{method}{
    The method used to generate estimates.
}
  \item{df}{
    Degrees of freedom of the estimates.
}
  \item{estimates}{
    Estimates generated by the selected method with standard deviations and 
    associated t- and p-values.
}
  \item{error.margins}{
    A list returning, for each margin, the absolute maximum deviation between 
    the desired and generated margin.
}
  \item{vcov}{
    A covariance matrix of the estimates (last index move fastest) computed 
    using the method specified in \code{cov.method}.
}
  \item{tab.gof}{
    A table containing the Log-likelihood (G2), Wald (W2) and Pearson 
    chi-squared (X2) statistics with their associated p-values.
}
  \item{stats.df}{
    Degrees of freedom for the \code{G2}, \code{W2} and \code{X2} statistics.
}
  \item{dim.names}{
    Original dimension names of the estimated table.
}
  \item{l.names}{
    The value of the parameter \code{l.names}.
  }
}
\author{
Johan Barthelemy.

Maintainer: Johan Barthelemy \email{johan@uow.edu.au}.
}
\note{
When using \code{print} for printing the resulting \code{mipfp} object, you can
also have a look at the options of the method \code{\link[mipfp:flat]{flat}}.
}
\seealso{
The estimation function \code{\link[mipfp:Estimate]{Estimate}}.

The function \code{\link[mipfp:coef.mipfp]{coef.mipfp}} to extract the 
estimates.

\code{\link[mipfp:gof.estimates]{gof.estimates}} for the computation of the 
\code{G2}, \code{W2} and \code{X2} statistics. 

\code{\link[mipfp:vcov.mipfp]{vcov.mipfp}} for the details of the covariance 
computation.
}
\examples{
# loading the data
data(spnamur, package = "mipfp")
# subsetting the data frame, keeping only the first 3 variables
spnamur.sub <- subset(spnamur, select = Household.type:Prof.status)
# true table
true.table <- table(spnamur.sub)
# extracting the margins
tgt.v1        <- apply(true.table, 1, sum)
tgt.v1.v2     <- apply(true.table, c(1,2), sum)
tgt.v2.v3     <- apply(true.table, c(2,3), sum)
tgt.list.dims <- list(1, c(1,2), c(2,3))
tgt.data      <- list(tgt.v1, tgt.v1.v2, tgt.v2.v3)
# creating the seed, a 10 pct sample of spnamur
seed.df <- spnamur.sub[sample(nrow(spnamur), round(0.10*nrow(spnamur))), ]
seed.table <- table(seed.df)
# applying the different fitting methods
r.ipfp <- Estimate(seed=seed.table, target.list=tgt.list.dims, 
                   target.data = tgt.data)
# printing the summary                   
print(summary(r.ipfp))
}
\keyword{models}
\keyword{multivariate}
\keyword{array}
\concept{iterative proportional fitting procedure}
\concept{ipfp}
\concept{multiway contingency table update}
\concept{multiway contingency table estimation}
\concept{multivariate contingency table estimation}
\concept{RAS algorithm}
\concept{matrix raking}
\concept{matrix scaling}