% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/individual.R
\name{dir2md}
\alias{dir2md}
\title{Display a directory hierarchical structure in Markdown syntax}
\usage{
dir2md(from = ".", dir_files = TRUE, dir_all = TRUE, dir_excluded = NA)
}
\arguments{
\item{from}{Character. The source text of the (R) Markdown syntax text, the R code, the FreeMind mind map code, or the path to the directory.}

\item{dir_files}{Logical. Whether to include files. If \code{FALSE}, only folders are included. If \code{TRUE}, folders and files are included.}

\item{dir_all}{Logical. Whether to include all files in a directory. If \code{FALSE}, only the names of visible files are included (following Unix-style visibility, that is files whose name does not start with a dot). If \code{TRUE}, all file names will be included.}

\item{dir_excluded}{Character. The directories which are not included in the output.}
}
\value{
Character, in Markdown syntax.
}
\description{
Display a directory hierarchical structure in Markdown syntax
}
\examples{
input <- system.file(package = "mindr")
dir2md(input)
dir2md(input, dir_files = FALSE, dir_all = TRUE, dir_excluded = "Meta")
output_txt <- dir2md(input)
output <- tempfile(pattern = "file", tmpdir = tempdir(), fileext = ".Rmd")
writeLines(output_txt, output, useBytes = TRUE)
message("Input:  ", input, "\nOutput: ", output)
# file.show(output) # Open the output file file.remove(output) # remove the
# output file
}
