% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foo.R
\name{outline}
\alias{outline}
\title{Extract headers of markdown or rmarkdown files as an outline.}
\usage{
outline(folder = "mm", remove_curly_bracket = FALSE, savefile = TRUE, 
    savefilename = "outline", backup = TRUE)
}
\arguments{
\item{folder}{character. The folder which contains the input file(s).}

\item{remove_curly_bracket}{logical. Whether to remove {#ID} in the headers of the markdown file (usually in a 'bookdown' \url{https://github.com/rstudio/bookdown} project).}

\item{savefile}{logical. Whether to save the output as a markdown file.}

\item{savefilename}{character. Valid when savefile == TRUE.}

\item{backup}{logical. Whether the existing target file, if any, should be saved as backups.}
}
\value{
a vector of strings showing outline of a markdown document or book.
}
\description{
Extract headers of markdown or rmarkdown files as an outline.
}
\examples{
folder <- system.file("examples/md", package = "mindr")
outline(folder = folder)
outline(folder = folder, remove_curly_bracket = TRUE)
}
