
### Transfer data to MIM

toMIM <- function(data) UseMethod("toMIM", data)

toMIM.data.frame <- function(data){    
  gmd <- as.gmData(data)
  toMIM(gmd)
}

toMIM.table <- function(data){         
  gmd <- as.gmData(data)
  toMIM(gmd)
}

toMIM.momentstats <- function(data){   
  gmd <- as.gmData(data)
  toMIM(gmd)
}

.NULL.to.mim <- function(data){
  .varspec.toMIM(data,text="# gmData without observations")
}

toMIM.gmData <- function(data){
  ##mim.cmd("clear; clear output")
  do <- .dataOrigin(data)
  if (is.null(do))
    .NULL.to.mim(data)
  else
    switch(.dataOrigin(data),
           "data.frame"    = {.dataframe.to.mim(data)    },
           "table"         = {.table.to.mim(data)        },
           "momentstats"   = {.momentstats.to.mim(data)  })
  
#   v <- attr(data,"ordinal")
#   if (!is.null(v)){
#     s<-paste("# Ordinal", paste(v, collapse=" "));
#     mim.cmd(s, look.nice=FALSE)
#     v2 <- names2letters(v, data)
#     s<-paste("Ordinal", paste(v2, collapse=" "));
#     mim.cmd(s, look.nice=FALSE)
#   }

}




.dataframe.to.mim <- function(data,file="mimR_df2mim.txt"){

  ##mygetwd <- function()gsub("/","\\\\",getwd())
  mygetwd <- function()gsub("/","\\\\",tempdir())
  
  nt <- as.data.frame(data)
  vs <- .namesTable.to.varspec(nt)

  mdata <- observations(data)
  for (j in 1:ncol(mdata))
    mdata[,j] <- as.numeric(mdata[,j])
  str4     <- unlist( lapply( as.vector(t(mdata)), .float.to.string, n.digits=3,
                             width=2))

  var.letter <- names2letters(names(mdata),nt)

  file <- paste(mygetwd(),"\\",file,sep='')
  
  tmp <- proc.time()
  ##cat("Writing MIM data file (in working dir)", specfile,"... ")
  write("%\n% DATA FILE AUTOMATICALLY GENERATED BY mimR", file, append=FALSE)
  write(paste("% TIME:", date(),  "%"), file, append=TRUE)
  write(paste("% FILE:", file,  "\n%"), file, append=TRUE)

  lapply(vs, write, file,append=TRUE)
  write(paste("Read", paste(var.letter, collapse=' ')), file, append=TRUE)  

  write(str4, file, append=TRUE, ncolumns=20)
  write("!", file, append=TRUE)

  mim.cmd(paste("clear; clear output;"))
  str  <- paste("input", file, ";", sep=' ');
  mim.cmd(str, look.nice=FALSE);  
  Sys.sleep(2)
  ##mim.cmd("pr d");
  ##cat("Time taken:", (proc.time()-tmp)[3],"\n")
  return(file)
}



# .dataframe.to.mim <- function(data,file="mimR_df2mim"){

#   mygetwd <- function()gsub("/","\\\\",getwd())
  
#   nt <- as.data.frame(data)
#   vs <- .namesTable.to.varspec(nt)

#   mdata <- observations(data)
#   for (j in 1:ncol(mdata))
#     mdata[,j] <- as.numeric(mdata[,j])
#   str4     <- unlist( lapply( as.vector(t(mdata)), .float.to.string, n.digits=3,
#                              width=2))

#   var.letter <- names2letters(names(mdata),nt)

#   file <- paste(mygetwd(),"\\",file,sep='')
  
#   tmp <- proc.time()
#   ##cat("Writing MIM data file (in working dir)", specfile,"... ")
#   write("%\n% DATA FILE AUTOMATICALLY GENERATED BY mimR", file, append=FALSE)
#   write(paste("% TIME:", date(),  "%"), file, append=TRUE)
#   write(paste("% FILE:", file,  "\n%"), file, append=TRUE)

#   lapply(vs, write, file,append=TRUE)
#   print(vs)
#   lapply(vs, function(x){if (!is.null(x)) mim.cmd(x)})
  
#   str <- paste("Read", paste(var.letter, collapse=' ')) 
#   write(str, file, append=TRUE)  
#   print(str)
#   mim.cmd(str)
#   lapply(.partition.mim.input(str4),mim.cmd)
#   mim.cmd("!")

#   ##print(.partition.mim.input(str4))
  
#   #write(str4, file, append=TRUE, ncolumns=20)
#   #write("!", file, append=TRUE)
#   #print(str4)
  
#   #mim.cmd(paste("clear; clear output;"))
#   #str  <- paste("input", file, ";", sep=' ');
#   #mim.cmd(str, look.nice=FALSE);  

  
  
#   #lapply(.partition.mim.input(vs),mim.cmd)

#   ##mim.cmd("pr d");
#   ##cat("Time taken:", (proc.time()-tmp)[3],"\n")
#   #return(file)
# }


.table.to.mim <- function(data){
  .varspec.toMIM(data,text="# Sufficient statistics from 'table'")

  ss <- data$letter
  ss <- ss[length(ss):1]
  s  <- paste("Statread", paste(ss, collapse=''))
  mim.cmd(s)
  res <- as.vector(observations(data))
  lapply(.partition.mim.input(res),mim.cmd)
  mim.cmd("!", look.nice=FALSE)    
}



.momentstats.to.mim <- function(data){
  vs <-.namesTable.to.varspec(data)
  a<- lapply(vs, paste)
  a<- a[lapply(a,length)>0]
  lapply(a, mim.cmd)
  res<- t(.getdata(observations(data)))

  s  <- paste("Statread", paste(data$letter, collapse=''))
  mim.cmd(s)
  lapply(.partition.mim.input(res),mim.cmd)
  mim.cmd("!", look.nice=FALSE)    
}




.getdata <- function(x){
  switch(class(x)[2],
         'mixed'={
           if (is.null(x$cmc))
             t(mapply(function(x,y,z) {c(x,y, z[lower.tri(z, diag=TRUE)])}, 
                    x$counts, x$means, x$covariances))
           else
             do.call("rbind",
                     lapply(x$cmc,
                            function(z)c(z[[3]],z[[2]],
                                         z[[1]][lower.tri(z[[1]], diag=TRUE)])))
         },
         'continuous'={
           if (is.null(x$cmc))
             c(x$counts, x$means, x$covariances[lower.tri(x$covariances, diag=TRUE)])
           else{
             z <- x$cmc
             c(z[[3]],z[[2]],z[[1]][lower.tri(z[[1]], diag=TRUE)])
           }
  
         },
         'discrete'={
           x$counts
         })
}




.namesTable.to.varspec <- function(nt){
  var.spec <-
    paste(paste("Fact", paste(nt$letter[nt$factor==TRUE],nt$levels[nt$factor==TRUE],
                              collapse=' ')), ";",
          paste("Cont", paste(nt$letter[nt$factor==FALSE],collapse=' '))  )
  
  lab.spec <- paste("Labels", nt$letter,
                    gsub(' ','',paste('\"',nt$name,'\"'))     )

  vallab.list <- NULL

  factor.letter <- nt$letter[nt$factor==TRUE]
  factor.levels <- nt$levels[nt$factor==TRUE]
  if (length(factor.letter)>0){
    vl <- attr(nt, "vallabels")
    for (j in 1:length(factor.letter)){
      x1 <- paste("ValLabel", factor.letter[j])
      x2 <- paste(1:factor.levels[j], gsub(' ','',paste('\"',vl[[j]],'\"')))
      x <- paste(x1,paste(x2,collapse=' '))
      vallab.list <- c(vallab.list, x)
    }
  }
  value<-list("var.spec"=var.spec, "lab.spec"=lab.spec,"vallab.spec"=vallab.list)
}

###
### local to toMIMxxxx.R
###

.partition.mim.input <- function(input,token=NULL){    
  curr     <- input
  n.char   <- 50 
  res <- NULL
    while(sum(nchar(curr))>n.char){
    cs <- cumsum(nchar(curr)+1)
    res <- c(res, paste(curr[cs<=n.char], collapse=' '))
    curr <- curr[!(cs<=n.char)]
  }
  value <- c(res, paste(curr, collapse=' '))
  return(value)
}




.float.to.string <-
  function(num.vec,n.digits=6,width=9, preserve.int=TRUE){
    if (is.na(num.vec) || is.null(num.vec))
      return("*")
    else{
      if ((num.vec-round(num.vec))==0)
        return( sprintf("%g",num.vec) )
      else
        return( sprintf("%.5f",num.vec) ) 
    }
  }




