% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_hp_performance}
\alias{plot_hp_performance}
\title{Plot hyperparameter performance metrics}
\usage{
plot_hp_performance(dat, param_col, metric_col)
}
\arguments{
\item{dat}{dataframe of hyperparameters and performance metric (e.g. from \code{get_hp_performance()} or \code{combine_hp_performance()})}

\item{param_col}{hyperparameter to be plotted. must be a column in \code{dat}.}

\item{metric_col}{performance metric. must be a column in \code{dat}.}
}
\value{
ggplot of hyperparameter performance.
}
\description{
Plot hyperparameter performance metrics
}
\examples{
# plot for a single `run_ml()` call
hp_metrics <- get_hp_performance(otu_mini_bin_results_glmnet$trained_model)
hp_metrics
plot_hp_performance(hp_metrics$dat, lambda, AUC)
\dontrun{
# plot for multiple `run_ml()` calls
results <- lapply(seq(100, 102), function(seed) {
  run_ml(otu_small, "glmnet", seed = seed)
})
models <- lapply(results, function(x) x$trained_model)
hp_metrics <- combine_hp_performance(models)
plot_hp_performance(hp_metrics$dat, lambda, AUC)
}
}
\author{
Zena Lapp, \email{zenalapp@umich.edu}

Kelly Sovacool \email{sovacool@umich.edu}
}
