% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partition.R
\name{get_partition_indices}
\alias{get_partition_indices}
\title{Select indices to partition the data into training & testing sets.}
\usage{
get_partition_indices(
  outcomes,
  training_frac = 0.8,
  groups = NULL,
  group_partitions = NULL
)
}
\arguments{
\item{outcomes}{vector of outcomes}

\item{training_frac}{Fraction of data for training set (default: \code{0.8}). Rows
from the dataset will be randomly selected for the training set, and all
remaining rows will be used in the testing set. Alternatively, if you
provide a vector of integers, these will be used as the row indices for the
training set. All remaining rows will be used in the testing set.}

\item{groups}{Vector of groups to keep together when splitting the data into
train and test sets, and for cross-validation.
Length matches the number of rows in the dataset (default: \code{NULL}).}

\item{group_partitions}{Specify how to assign \code{groups} to the training and
testing partitions (default: \code{NULL}). If \code{groups} specifies that some
samples belong to group \code{"A"} and some belong to group \code{"B"}, then setting
\code{group_partitions = list(train = c("A", "B"), test = c("B"))} will result
in all samples from group \code{"A"} being placed in the training set, some
samples from \code{"B"} also in the training set, and the remaining samples from
\code{"B"} in the testing set. The partition sizes will be as close to
\code{training_frac} as possible.}
}
\value{
Vector of row indices for the training set.
}
\description{
Use this function to get the row indices for the training set.
}
\details{
If \code{groups} is \code{NULL}, uses \link[caret]{createDataPartition}.
Otherwise, uses \code{create_grouped_data_partition()}.

Set the seed prior to calling this function if you would like your data
partitions to be reproducible (recommended).
}
\examples{
training_inds <- get_partition_indices(otu_mini_bin$dx)
train_data <- otu_mini_bin[training_inds, ]
test_data <- otu_mini_bin[-training_inds, ]
}
\author{
Kelly Sovacool, {sovacool@umich.edu}
}
