% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miic.export.R
\name{miic.export}
\alias{miic.export}
\title{Export miic result to different plotting methods}
\usage{
miic.export(miic.res, method = NULL)
}
\arguments{
\item{miic.res}{[a miic graph object]
The graph object returned by the miic execution.}

\item{method}{A string representing the plotting method.
Currently only "igraph" is supported.}
}
\value{
A graph object adapted to the method.
}
\description{
This function creates an object built from the result returned
by \code{\link{miic}} that is ready to be fed to different plotting methods.
}
\details{
See the details of specific function for each method.
For igraph, see \code{\link{getIgraph}}.
}
\examples{
\donttest{
library(miic)
data(hematoData)

# execute MIIC (reconstruct graph)
miic.res <- miic(
  input_data = hematoData, latent = "yes",
  n_shuffles = 10, conf_threshold = 0.001
)

# Using igraph
if(require(igraph)) {
g = miic.export(miic.res, "igraph")
plot(g) # Default visualisation, calls igraph::plot.igraph()

# Specifying layout (see ?igraph::layout_)
l <-layout_with_kk(g)
plot(g, layout=l)

# Override some graphical parameters
plot(g, edge.curved = .2)
plot(g, vertex.shape="none", edge.color="gray85", vertex.label.color="gray10")
}

}

}
\seealso{
\code{\link{getIgraph}} for details on the igraph exported object.
}
