% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre_process.R
\name{pre_process}
\alias{pre_process}
\title{A function to convert a large data into a number of sub groups}
\usage{
pre_process(data, init_res_status_data = NULL, n_groups = 1)
}
\arguments{
\item{data}{A dataframe object.}

\item{init_res_status_data}{The raw data of the initial residence status
in the format of data frame.}

\item{n_groups}{The number of groups required to be returned.}
}
\value{
A list object contains reformatted raw data.
}
\description{
This function provides a mechanism to divide large data into
small chunks.
}
\examples{
## to suppresse log messages to the console
migrbc::initialize_logger(log_level = 1)

number_of_people = 10
person_data <- migrbc::setup_random_test_data(number_of_people, 
                                              initial_date = '2001-01-01', 
                                              numJourneys = 5,
                                              min = 0, 
                                              max = 10)
crossings <- migrbc::pre_process(person_data, n_groups = 10)
crossings

}
