% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{tests}
\alias{tests}
\alias{test_random}
\alias{test_permutation}
\title{Conditional uniform graph and permutation tests}
\usage{
test_random(object, FUN, ..., nSim = 1000)

test_permutation(object, FUN, ..., nSim = 1000)
}
\arguments{
\item{object}{A data frame edgelist, matrix, igraph, tidygraph, or
network object.}

\item{FUN}{A graph-level statistic function to test.}

\item{...}{Additional arguments to be passed on to FUN,
e.g. the name of the attribute.}

\item{nSim}{The number of Monte Carlo simulations to perform.}
}
\description{
These functions conduct conditional uniform graph (CUG)
or permutation (QAP) tests of any graph-level statistic.
}
\examples{
marvel_friends <- to_unsigned(ison_marvel_relationships)
marvel_friends <- to_main_component(marvel_friends) \%>\% 
  filter(PowerOrigin == "Human")
(cugtest <- test_random(marvel_friends, graph_ei_index, attribute = "Attractive",
  nSim = 200))
plot(cugtest)
(qaptest <- test_permutation(marvel_friends, graph_ei_index, attribute = "Attractive",
  nSim = 200))
plot(qaptest)
}
