% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netlm.R
\name{netlm}
\alias{netlm}
\alias{summary.netlm}
\alias{print.summary.netlm}
\title{Linear regression for multimodal network data}
\usage{
netlm(formula, data, ...)

\method{summary}{netlm}(object, reps = 1000, ...)

\method{print}{summary.netlm}(
  x,
  digits = max(3, getOption("digits") - 3),
  signif.stars = getOption("show.signif.stars"),
  ...
)
}
\arguments{
\item{formula}{A formula describing the relationship being tested.}

\item{data}{A named list of matrices, graphs, or a tidygraph object.}

\item{...}{Arguments passed on to \code{lm()}.}

\item{object}{an object of class "netlm", usually as a result of a call to \code{netlm()}.}

\item{reps}{Integer indicating the number of draws to use for quantile estimation.
(Relevant to the null hypothesis test only - the analysis itself is unaffected by this parameter.)
Note that, as for all Monte Carlo procedures, convergence is slower for more extreme quantiles.
By default, reps=1000.}

\item{x}{an object of class "summary.netlm", usually, a result of a call to \code{summary.netlm()}.}

\item{digits}{the number of significant digits to use when printing.}

\item{signif.stars}{logical. If TRUE, ‘significance stars’ are printed for each coefficient.}
}
\description{
This function extends the multiple regression quadratic assignment procedure (MRQAP)
of network linear model to two mode networks.
}
\examples{
mat1 <- matrix(c(0,1,1,0,0,1,1,1),4,2)
mat2 <- matrix(c(0,1,0,1,0,1,0,1),4,2)
mat3 <- matrix(c(0,0,1,1,0,0,1,1),4,2)
lmat <- list(mat1 = mat1, mat2 = mat2, mat3 = mat3)
model1 <- netlm(mat1 ~ mat2 + mat3, lmat)
summary(model1)
}
