% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip_to.R
\name{split}
\alias{split}
\alias{to_egos}
\alias{to_subgraphs}
\alias{to_components}
\title{Tools for splitting networks, graphs, and matrices}
\usage{
to_egos(object, max_dist = 1, min_dist = 0)

to_subgraphs(object, attribute)

to_components(object)
}
\arguments{
\item{object}{An object of a migraph-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{max_dist}{The maximum breadth of the neighbourhood.
By default 1.}

\item{min_dist}{The minimum breadth of the neighbourhood.
By default 0.
Increasing this to 1 excludes the ego,
and 2 excludes ego's direct alters.}

\item{attribute}{A character string indicating the categorical
attribute in a network used to split into subgraphs.}
}
\description{
These functions offer tools for splitting migraph-consistent objects
(matrices, igraph, tidygraph, or network objects).
Splitting means that the returned object will be a list of objects.
}
\section{Functions}{
\itemize{
\item \code{to_egos()}: Returns a list of ego (or focal)
networks.

\item \code{to_subgraphs()}: Returns a list of subgraphs
on some given attribute.

\item \code{to_components()}: Returns a list of the components
in a network.

}}
\examples{
autographs(to_egos(ison_adolescents))
autographs(to_egos(ison_adolescents,2))
to_components(ison_marvel_relationships)
}
\seealso{
Other manipulations: 
\code{\link{add}},
\code{\link{as}()},
\code{\link{grab}},
\code{\link{reformat}},
\code{\link{transform}()}
}
\concept{manipulations}
