% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandwidth.R
\name{mig_kdens}
\alias{mig_kdens}
\title{Multivariate inverse Gaussian kernel density estimator}
\usage{
mig_kdens(x, newdata, Omega, beta, log = FALSE)
}
\arguments{
\item{x}{\code{n} by \code{d} matrix of quantiles}

\item{newdata}{matrix of new observations at which to evaluated the kernel density}

\item{Omega}{\code{d} by \code{d} positive definite scale matrix \eqn{\boldsymbol{\Omega}}}

\item{beta}{\code{d} vector \eqn{\boldsymbol{\beta}} defining the half-space through \eqn{\boldsymbol{\beta}^{\top}\boldsymbol{\xi}>0}}

\item{log}{logical; if \code{TRUE}, returns log probabilities}
}
\value{
value of the (log)-density at \code{newdata}
}
\description{
Given a matrix of new observations, compute the density of the multivariate
inverse Gaussian mixture defined by assigning equal weight to each component where
\eqn{\boldsymbol{\xi}} is the location parameter.
}
