% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MutatorCmpMaybe.R
\name{dict_mutators_cmpmaybe}
\alias{dict_mutators_cmpmaybe}
\alias{MutatorCmpMaybe}
\title{Mutator Choosing Action Component-Wise Independently}
\description{
\code{\link{Mutator}} that chooses which operation to perform probabilistically. The \code{\link{Mutator}} wraps two other \code{\link{Mutator}}s given during construction,
and both of these operators are run. The ultimate result is sampled from the results of these operations independently for each
individuum and component: with probability \code{p} (configuration parameter), the result from the \code{\link{Mutator}} given to the \code{mutator}
construction argument is used, and with probability \code{p - 1} the one given to \code{mutator_not} is used.
}
\section{Configuration Parameters}{

This operator has the configuration parameters of the \code{\link{Mutator}}s that it wraps: The configuration parameters of the operator given to the \code{mutator} construction argument
are prefixed with \code{"cmpmaybe."}, the configuration parameters of the operator given to the \code{mutator_not} construction argument are prefixed with \code{"cmpmaybe_not."}.

Additional configuration parameters:
\itemize{
\item \code{p} :: \code{numeric(1)} \cr
Probability per component with which to apply the operator given to the \code{mutator} construction argument. Must be set by the user.
}
}

\section{Supported Operand Types}{


Supported \code{\link[paradox:Domain]{Domain}} classes are the set intersection of supported classes of \code{mutator} and \code{mutator_not}.
}

\section{Dictionary}{

This \code{\link{Mutator}} can be created with the short access form \code{\link[=mut]{mut()}}
(\code{\link[=muts]{muts()}} to get a list), or through the the \link[mlr3misc:Dictionary]{dictionary}
\code{\link{dict_mutators}} in the following way:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# preferred:
mut("cmpmaybe", <mutator> [, <mutator_not>])
muts("cmpmaybe", <mutator> [, <mutator_not>])  # takes vector IDs, returns list of Mutators

# long form:
dict_mutators$get("cmpmaybe", <mutator> [, <mutator_not>])
}\if{html}{\out{</div>}}
}

\examples{
set.seed(1)
mcm = mut("cmpmaybe", mut("gauss", sdev = 5), p = 0.5)
p = ps(x = p_int(-5, 5), y = p_dbl(-5, 5))
data = data.frame(x = rep(0, 5), y = rep(0, 5))

mcm$prime(p)
mcm$operate(data)

mcm$param_set$values$p = 0.2
mcm$operate(data)

mcm2 = mut("cmpmaybe",
  mutator = mut("gauss", sdev = 0.01),
  mutator_not = mut("gauss", sdev = 10),
  p = 0.5
)

mcm2$prime(p)
mcm2$operate(data)
}
\seealso{
Other mutators: 
\code{\link{Mutator}},
\code{\link{MutatorDiscrete}},
\code{\link{MutatorNumeric}},
\code{\link{OperatorCombination}},
\code{\link{dict_mutators_erase}},
\code{\link{dict_mutators_gauss}},
\code{\link{dict_mutators_maybe}},
\code{\link{dict_mutators_null}},
\code{\link{dict_mutators_proxy}},
\code{\link{dict_mutators_sequential}},
\code{\link{dict_mutators_unif}}

Other mutator wrappers: 
\code{\link{OperatorCombination}},
\code{\link{dict_mutators_maybe}},
\code{\link{dict_mutators_proxy}},
\code{\link{dict_mutators_sequential}}
}
\concept{mutator wrappers}
\concept{mutators}
\section{Super classes}{
\code{\link[miesmuschel:MiesOperator]{miesmuschel::MiesOperator}} -> \code{\link[miesmuschel:Mutator]{miesmuschel::Mutator}} -> \code{MutatorCmpMaybe}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{mutator}}{(\code{\link{Mutator}})\cr
\code{\link{Mutator}} being wrapped. This operator gets run with probability \code{p} (configuration parameter).}

\item{\code{mutator_not}}{(\code{\link{Mutator}})\cr
Alternative \code{\link{Mutator}} being wrapped. This operator gets run with probability \code{1 - p} (configuration parameter).}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MutatorCmpMaybe-new}{\code{MutatorCmpMaybe$new()}}
\item \href{#method-MutatorCmpMaybe-prime}{\code{MutatorCmpMaybe$prime()}}
\item \href{#method-MutatorCmpMaybe-clone}{\code{MutatorCmpMaybe$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="help"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-help'><code>miesmuschel::MiesOperator$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="operate"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-operate'><code>miesmuschel::MiesOperator$operate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="print"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-print'><code>miesmuschel::MiesOperator$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="repr"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-repr'><code>miesmuschel::MiesOperator$repr()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MutatorCmpMaybe-new"></a>}}
\if{latex}{\out{\hypertarget{method-MutatorCmpMaybe-new}{}}}
\subsection{Method \code{new()}}{
Initialize the \code{MutatorCmpMaybe} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MutatorCmpMaybe$new(mutator, mutator_not = MutatorNull$new())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mutator}}{(\code{\link{Mutator}})\cr
\code{\link{Mutator}} to wrap. Component-wise results of this operator are used with probability \code{p} (Configuration parameter).\cr
The constructed object gets a \emph{clone} of this argument.
The \verb{$mutator} field will reflect this value.}

\item{\code{mutator_not}}{(\code{\link{Mutator}})\cr
Another \code{\link{Mutator}} to wrap. Results from this operator are used when \code{mutator} is not chosen. By
default, this is \code{\link{MutatorNull}}, i.e. no operation.\cr
With this default, the
\code{MutatorCmpMaybe} object applies the \code{mutator} operation with probability \code{p}, and
no operation at all otherwise.\cr
The constructed object gets a \emph{clone} of this argument.
The \verb{$mutator_not} field will reflect this value.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MutatorCmpMaybe-prime"></a>}}
\if{latex}{\out{\hypertarget{method-MutatorCmpMaybe-prime}{}}}
\subsection{Method \code{prime()}}{
See \code{\link{MiesOperator}} method. Primes both this operator, as well as the wrapped operators
given to \code{mutator} and \code{mutator_not} during construction.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MutatorCmpMaybe$prime(param_set)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{param_set}}{(\code{\link[paradox:ParamSet]{ParamSet}})\cr
Passed to \code{\link{MiesOperator}}\verb{$prime()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{invisible} \code{self}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MutatorCmpMaybe-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MutatorCmpMaybe-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MutatorCmpMaybe$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
