% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScalorNondom.R
\name{dict_scalors_nondom}
\alias{dict_scalors_nondom}
\alias{ScalorNondom}
\title{Nondominated Sorting Scalor}
\description{
\code{\link{Scalor}} that returns a the rank of the pareto-front in nondominated sorting as scale. Higher ranks
indocate higher fitnesses and therefore "better" individuals.
}
\section{Configuration Parameters}{

\itemize{
\item \code{epsilon}
\item \code{nadir}
\item \code{jitter}
\item \code{scale_output}
\item \code{tiebreak}
}
}

\section{Supported Operand Types}{


Supported \code{\link[paradox:Param]{Param}} classes are: \code{\link[paradox:ParamLgl]{ParamLgl}}, \code{\link[paradox:ParamInt]{ParamInt}}, \code{\link[paradox:ParamDbl]{ParamDbl}}, \code{\link[paradox:ParamFct]{ParamFct}}
}

\section{Dictionary}{

This \code{\link{Scalor}} can be created with the short access form \code{\link[=scl]{scl()}}
(\code{\link[=scls]{scls()}} to get a list), or through the the \link[mlr3misc:Dictionary]{dictionary}
\code{\link{dict_scalors}} in the following way:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# preferred:
scl("nondom")
scls("nondom")  # takes vector IDs, returns list of Scalors

# long form:
dict_scalors$get("nondom")
}\if{html}{\out{</div>}}
}

\examples{
so = scl("nondom")
p = ps(x = p_dbl(-5, 5))
# dummy data; note that ScalorNondom does not depend on data content
data = data.frame(x = rep(0, 5))
fitnesses = matrix(c(1, 5, 2, 3, 0, 3, 1, 0, 10, 8), ncol = 2)

so$prime(p)

so$operate(data, fitnesses)
}
\seealso{
Other scalors: 
\code{\link{Scalor}},
\code{\link{dict_scalors_aggregate}},
\code{\link{dict_scalors_domcount}},
\code{\link{dict_scalors_fixedprojection}},
\code{\link{dict_scalors_hypervolume}},
\code{\link{dict_scalors_one}},
\code{\link{dict_scalors_proxy}},
\code{\link{dict_scalors_single}}
}
\concept{scalors}
\section{Super classes}{
\code{\link[miesmuschel:MiesOperator]{miesmuschel::MiesOperator}} -> \code{\link[miesmuschel:Scalor]{miesmuschel::Scalor}} -> \code{ScalorNondom}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ScalorNondom-new}{\code{ScalorNondom$new()}}
\item \href{#method-ScalorNondom-clone}{\code{ScalorNondom$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="help"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-help'><code>miesmuschel::MiesOperator$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="operate"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-operate'><code>miesmuschel::MiesOperator$operate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="prime"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-prime'><code>miesmuschel::MiesOperator$prime()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="print"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-print'><code>miesmuschel::MiesOperator$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="repr"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-repr'><code>miesmuschel::MiesOperator$repr()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ScalorNondom-new"></a>}}
\if{latex}{\out{\hypertarget{method-ScalorNondom-new}{}}}
\subsection{Method \code{new()}}{
Initialize the \code{ScalorNondom} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ScalorNondom$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ScalorNondom-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ScalorNondom-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ScalorNondom$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
