% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{midas_pl_sim}
\alias{midas_pl_sim}
\title{Simulate PL MIDAS regression model}
\usage{
midas_pl_sim(
  n,
  m,
  theta,
  gfun,
  ar.x,
  ar.y,
  rand.gen = rnorm,
  n.start = NA,
  ...
)
}
\arguments{
\item{n}{number of observations to simulate.}

\item{m}{integer, frequency ratio}

\item{theta}{vector, restriction coefficients for high frequency variable}

\item{gfun}{function, a function which takes a single index}

\item{ar.x}{vector, AR parameters for simulating high frequency variable}

\item{ar.y}{vector, AR parameters for AR part of the model}

\item{rand.gen}{function, a function for generating the regression innovations, default is \code{rnorm}}

\item{n.start}{integer, length of a 'burn-in' period. If NA, the default, a reasonable value is computed.}

\item{...}{additional parameters to rand.gen}
}
\value{
a list
}
\description{
Simulate PL MIDAS regression model
}
\examples{

nnbeta <- function(p, k) nbeta(c(1,p),k)

dgp <- midas_pl_sim(250, m = 12, theta = nnbeta(c(2, 4), 24), 
                           gfun = function(x) 0.25*x^3, 
                           ar.x = 0.9, ar.y = 0.5, n.start = 100)
                           
}
