% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/midas_nlpr.R
\name{midas_nlpr}
\alias{midas_nlpr}
\title{Non-linear parametric MIDAS regression}
\usage{
midas_nlpr(formula, data, start, Ofunction = "optim", ...)
}
\arguments{
\item{formula}{formula for restricted MIDAS regression or \code{midas_r} object. Formula must include \code{\link{fmls}} function}

\item{data}{a named list containing data with mixed frequencies}

\item{start}{the starting values for optimisation. Must be a list with named elements.}

\item{Ofunction}{the list with information which R function to use for optimisation. The list must have element named \code{Ofunction} which contains character string of chosen 
R function. Other elements of the list are the arguments passed to this function.  The default optimisation function is \code{\link{optim}} with arguments
 \code{method="Nelder-Mead"} and \code{control=list(maxit=5000)}. Other supported functions are \code{\link{nls}}, \code{\link{optimx}}.}

\item{...}{additional arguments supplied to optimisation function}
}
\value{
a \code{midas_r} object which is the list with the following elements:

\item{coefficients}{the estimates of parameters of restrictions}
\item{midas_coefficients}{the estimates of MIDAS coefficients of MIDAS regression}
\item{model}{model data}
\item{unrestricted}{unrestricted regression estimated using \code{\link{midas_u}}}
\item{term_info}{the named list. Each element is a list with the information about the term, such as its frequency, function for weights, gradient function of weights, etc.}
\item{fn0}{optimisation function for non-linear least squares problem solved in restricted MIDAS regression}
\item{rhs}{the function which evaluates the right-hand side of the MIDAS regression}
\item{gen_midas_coef}{the function which generates the MIDAS coefficients of MIDAS regression}
\item{opt}{the output of optimisation procedure}
\item{argmap_opt}{the list containing the name of optimisation function together with arguments for optimisation function}
\item{start_opt}{the starting values used in optimisation}
\item{start_list}{the starting values as a list}
\item{call}{the call to the function}
\item{terms}{terms object}
\item{gradient}{gradient of NLS objective function}
\item{hessian}{hessian of NLS objective function}
\item{gradD}{gradient function of MIDAS weight functions} 
\item{Zenv}{the environment in which data is placed}
\item{nobs}{the number of effective observations}
\item{convergence}{the convergence message}
\item{fitted.values}{the fitted values of MIDAS regression}
\item{residuals}{the residuals of MIDAS regression}
}
\description{
Estimate restricted MIDAS regression using non-linear least squares.
}
\details{
Given MIDAS regression:

\deqn{y_t = \sum_{j=1}^p\alpha_jy_{t-j} +\sum_{i=0}^{k}\sum_{j=0}^{l_i}\beta_{j}^{(i)}x_{tm_i-j}^{(i)} + u_t,}

estimate the parameters of the restriction

\deqn{\beta_j^{(i)}=g^{(i)}(j,\lambda).}

Such model is a generalisation of so called ADL-MIDAS regression. It is not required that all the coefficients should be restricted, i.e the function \eqn{g^{(i)}}
might be an identity function. Model with no restrictions is called U-MIDAS model. The regressors \eqn{x_\tau^{(i)}} must be of higher
(or of the same) frequency as the dependent variable \eqn{y_t}.
}
\author{
Virmantas Kvedaras, Vaidotas Zemlys
}
