% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/microtable.R
\name{microtable}
\alias{microtable}
\title{Create microtable object to store and manage all the basic files.}
\format{
microtable.
}
\description{
This class is a wrapper for a series of operations on the original files and the basic manipulations,
including the microtable object creation, data reduction, data rarefaction based on Paul et al. (2013) <doi:10.1371/journal.pone.0061217>, taxa abundance calculation, 
alpha and beta diversity calculation based on the An et al. (2019) <doi:10.1016/j.geoderma.2018.09.035> and 
Lozupone et al. (2005) <doi:10.1128/AEM.71.12.8228–8235.2005> and other basic operations.
}
\examples{

## ------------------------------------------------
## Method `microtable$new`
## ------------------------------------------------

data(otu_table_16S)
data(taxonomy_table_16S)
data(sample_info_16S)
data(phylo_tree_16S)
dataset <- microtable$new(sample_table = sample_info_16S, otu_table = otu_table_16S, 
  tax_table = taxonomy_table_16S, phylo_tree = phylo_tree_16S)
# trim the dataset
dataset$tidy_dataset()

## ------------------------------------------------
## Method `microtable$filter_pollution`
## ------------------------------------------------

dataset$filter_pollution(taxa = c("mitochondria", "chloroplast"))

## ------------------------------------------------
## Method `microtable$rarefy_samples`
## ------------------------------------------------

\donttest{
dataset$rarefy_samples(sample.size = min(dataset$sample_sums()), replace = TRUE)
}

## ------------------------------------------------
## Method `microtable$tidy_dataset`
## ------------------------------------------------

dataset$tidy_dataset(main_data = TRUE)

## ------------------------------------------------
## Method `microtable$cal_abund`
## ------------------------------------------------

\donttest{
dataset$cal_abund()
}

## ------------------------------------------------
## Method `microtable$sample_sums`
## ------------------------------------------------

\donttest{
dataset$sample_sums()
}

## ------------------------------------------------
## Method `microtable$taxa_sums`
## ------------------------------------------------

\donttest{
dataset$taxa_sums()
}

## ------------------------------------------------
## Method `microtable$sample_names`
## ------------------------------------------------

\donttest{
dataset$sample_names()
}

## ------------------------------------------------
## Method `microtable$taxa_names`
## ------------------------------------------------

\donttest{
dataset$taxa_names()
}

## ------------------------------------------------
## Method `microtable$merge_samples`
## ------------------------------------------------

\donttest{
dataset$merge_samples(use_group = "Group")
}

## ------------------------------------------------
## Method `microtable$merge_taxa`
## ------------------------------------------------

\donttest{
dataset$merge_taxa(taxa = "Genus")
}

## ------------------------------------------------
## Method `microtable$cal_alphadiv`
## ------------------------------------------------

\donttest{
dataset$cal_alphadiv(measures = NULL, PD = FALSE)
class(dataset$alpha_diversity)
}

## ------------------------------------------------
## Method `microtable$cal_betadiv`
## ------------------------------------------------

\donttest{
dataset$cal_betadiv(unifrac = FALSE)
class(dataset$beta_diversity)
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{microtable$new()}}
\item \href{#method-print}{\code{microtable$print()}}
\item \href{#method-filter_pollution}{\code{microtable$filter_pollution()}}
\item \href{#method-rarefy_samples}{\code{microtable$rarefy_samples()}}
\item \href{#method-tidy_dataset}{\code{microtable$tidy_dataset()}}
\item \href{#method-cal_abund}{\code{microtable$cal_abund()}}
\item \href{#method-save_abund}{\code{microtable$save_abund()}}
\item \href{#method-sample_sums}{\code{microtable$sample_sums()}}
\item \href{#method-taxa_sums}{\code{microtable$taxa_sums()}}
\item \href{#method-sample_names}{\code{microtable$sample_names()}}
\item \href{#method-taxa_names}{\code{microtable$taxa_names()}}
\item \href{#method-merge_samples}{\code{microtable$merge_samples()}}
\item \href{#method-merge_taxa}{\code{microtable$merge_taxa()}}
\item \href{#method-cal_alphadiv}{\code{microtable$cal_alphadiv()}}
\item \href{#method-save_alphadiv}{\code{microtable$save_alphadiv()}}
\item \href{#method-cal_betadiv}{\code{microtable$cal_betadiv()}}
\item \href{#method-save_betadiv}{\code{microtable$save_betadiv()}}
\item \href{#method-clone}{\code{microtable$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$new(
  otu_table = NULL,
  sample_table = NULL,
  tax_table = NULL,
  phylo_tree = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{otu_table}}{data.frame; default NULL; necessary; The species or OTU table, rows are species, cols are samples.}

\item{\code{sample_table}}{data.frame; default NULL; The sample information table, rows are samples, cols are sample metadata.}

\item{\code{tax_table}}{data.frame; default NULL; The taxonomic information table, rows are species, cols are taxonomic classes.}

\item{\code{phylo_tree}}{phylo; default NULL; If provided, the phylogenetic tree can be used for some analysis, for example, phylogenetic diversity.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class "microtable" with the following components:
\describe{
  \item{\code{sample_table}}{The sample information table.}
  \item{\code{otu_table}}{The OTU table.}
  \item{\code{tax_table}}{The taxonomic table.}
  \item{\code{phylo_tree}}{The phylogenetic tree}
  \item{\code{taxa_abund}}{default NULL; use cal_abund function to calculate}
  \item{\code{alpha_diversity}}{default NULL; use cal_alphadiv function to calculate}
  \item{\code{beta_diversity}}{default NULL; use cal_betadiv function to calculate}
}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(otu_table_16S)
data(taxonomy_table_16S)
data(sample_info_16S)
data(phylo_tree_16S)
dataset <- microtable$new(sample_table = sample_info_16S, otu_table = otu_table_16S, 
  tax_table = taxonomy_table_16S, phylo_tree = phylo_tree_16S)
# trim the dataset
dataset$tidy_dataset()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Print the microtable object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-filter_pollution"></a>}}
\if{latex}{\out{\hypertarget{method-filter_pollution}{}}}
\subsection{Method \code{filter_pollution()}}{
Filter the taxa considered as pollution.
This operation will remove any line of the tax_table containing any the word in taxa parameter regardless of word case.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$filter_pollution(taxa = c("mitochondria", "chloroplast"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{taxa}}{default: c("mitochondria", "chloroplast"); filter mitochondria and chloroplast, or others as needed.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dataset$filter_pollution(taxa = c("mitochondria", "chloroplast"))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rarefy_samples"></a>}}
\if{latex}{\out{\hypertarget{method-rarefy_samples}{}}}
\subsection{Method \code{rarefy_samples()}}{
Rarefy communities to make all samples have same species number, modified from the rarefy_even_depth() in phyloseq package, 
see Paul et al. (2013) <doi:10.1371/journal.pone.0061217>.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$rarefy_samples(sample.size = NULL, rngseed = 123, replace = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sample.size}}{default:NULL; the required species number, If not provided, use minimum number of all samples.}

\item{\code{rngseed}}{random seed; default: 123.}

\item{\code{replace}}{default: TRUE; see \code{\link{sample}} for the random sampling.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None; rarefied dataset.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
dataset$rarefy_samples(sample.size = min(dataset$sample_sums()), replace = TRUE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tidy_dataset"></a>}}
\if{latex}{\out{\hypertarget{method-tidy_dataset}{}}}
\subsection{Method \code{tidy_dataset()}}{
Tidy the object of microtable Class.
Trim the dataset to make OTUs and samples consistent across all files in the object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$tidy_dataset(main_data = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{main_data}}{TRUE or FALSE, if TRUE, only basic files in microtable object is tidied, otherwise, all files, including taxa_abund, alpha_diversity and beta_diversity, are all trimed.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None, Object of microtable itself cleaned up.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dataset$tidy_dataset(main_data = TRUE)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_abund"></a>}}
\if{latex}{\out{\hypertarget{method-cal_abund}{}}}
\subsection{Method \code{cal_abund()}}{
Calculate the taxonomic abundance at each taxonomic ranks.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$cal_abund()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
taxa_abund in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
dataset$cal_abund()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-save_abund"></a>}}
\if{latex}{\out{\hypertarget{method-save_abund}{}}}
\subsection{Method \code{save_abund()}}{
Save taxonomic abundance to the computer local place.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$save_abund(dirpath = "taxa_abund")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dirpath}}{default "taxa_abund"; directory name to save the taxonomic abundance files.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sample_sums"></a>}}
\if{latex}{\out{\hypertarget{method-sample_sums}{}}}
\subsection{Method \code{sample_sums()}}{
Sum the species number for each sample.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$sample_sums()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
species number of samples.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
dataset$sample_sums()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-taxa_sums"></a>}}
\if{latex}{\out{\hypertarget{method-taxa_sums}{}}}
\subsection{Method \code{taxa_sums()}}{
Sum the species number for each taxa.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$taxa_sums()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
species number of taxa.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
dataset$taxa_sums()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sample_names"></a>}}
\if{latex}{\out{\hypertarget{method-sample_names}{}}}
\subsection{Method \code{sample_names()}}{
Sample names.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$sample_names()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
sample names.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
dataset$sample_names()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-taxa_names"></a>}}
\if{latex}{\out{\hypertarget{method-taxa_names}{}}}
\subsection{Method \code{taxa_names()}}{
Taxa names.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$taxa_names()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
taxa names.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
dataset$taxa_names()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-merge_samples"></a>}}
\if{latex}{\out{\hypertarget{method-merge_samples}{}}}
\subsection{Method \code{merge_samples()}}{
Merge samples according to specific group to generate a new microtable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$merge_samples(use_group)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use_group}}{the group column in sample_table.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a new created merged microtable object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
dataset$merge_samples(use_group = "Group")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-merge_taxa"></a>}}
\if{latex}{\out{\hypertarget{method-merge_taxa}{}}}
\subsection{Method \code{merge_taxa()}}{
Merge taxa according to specific taxonomic rank to generate a new microtable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$merge_taxa(taxa = "Genus")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{taxa}}{the specific rank in tax_table.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a new created merged microtable object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
dataset$merge_taxa(taxa = "Genus")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_alphadiv"></a>}}
\if{latex}{\out{\hypertarget{method-cal_alphadiv}{}}}
\subsection{Method \code{cal_alphadiv()}}{
Calculate alpha diversity in microtable Class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$cal_alphadiv(measures = NULL, PD = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{measures}}{one or more indexes from "Observed", "Coverage", "Chao1", "ACE", "Shannon", "Simpson", "InvSimpson", "Fisher", "PD"; default NULL, using all those measures.}

\item{\code{PD}}{TRUE or FALSE, whether phylogenetic tree should be calculated, default FALSE.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
alpha_diversity stored in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
dataset$cal_alphadiv(measures = NULL, PD = FALSE)
class(dataset$alpha_diversity)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-save_alphadiv"></a>}}
\if{latex}{\out{\hypertarget{method-save_alphadiv}{}}}
\subsection{Method \code{save_alphadiv()}}{
Save alpha diversity table to the computer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$save_alphadiv(dirpath = "alpha_diversity")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dirpath}}{default "alpha_diversity"; directory name to save the alpha_diversity.csv file.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_betadiv"></a>}}
\if{latex}{\out{\hypertarget{method-cal_betadiv}{}}}
\subsection{Method \code{cal_betadiv()}}{
Calculate beta diversity in microtable object, including Bray-Curtis, Jaccard, and UniFrac, 
see An et al. (2019) <doi:10.1016/j.geoderma.2018.09.035> and Lozupone et al. (2005) <doi:10.1128/AEM.71.12.8228–8235.2005>.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$cal_betadiv(unifrac = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{unifrac}}{TRUE or FALSE, whether unifrac index should be calculated, default FALSE.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
beta_diversity stored in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
dataset$cal_betadiv(unifrac = FALSE)
class(dataset$beta_diversity)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-save_betadiv"></a>}}
\if{latex}{\out{\hypertarget{method-save_betadiv}{}}}
\subsection{Method \code{save_betadiv()}}{
Save beta diversity matrix to the computer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$save_betadiv(dirpath = "beta_diversity")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dirpath}}{default "beta_diversity"; directory name to save the beta diversity matrix files.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
