% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_venn.R
\name{trans_venn}
\alias{trans_venn}
\title{Create trans_venn object.}
\description{
This class is a wrapper for a series of venn analysis related methods, including venn result, 2- to 5-way venn diagram, 
more than 5-way petal plot and venn result transformations based on David et al. (2012) <doi:10.1128/AEM.01459-12>.
}
\examples{

## ------------------------------------------------
## Method `trans_venn$new`
## ------------------------------------------------

\donttest{
data(dataset)
t1 <- dataset$merge_samples(use_group = "Group")
t1 <- trans_venn$new(dataset = t1, ratio = "numratio")
}

## ------------------------------------------------
## Method `trans_venn$plot_venn`
## ------------------------------------------------

\donttest{
t1$plot_venn()
}

## ------------------------------------------------
## Method `trans_venn$trans_comm`
## ------------------------------------------------

\donttest{
t2 <- t1$trans_comm(use_frequency = TRUE)
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{trans_venn$new()}}
\item \href{#method-plot_venn}{\code{trans_venn$plot_venn()}}
\item \href{#method-trans_comm}{\code{trans_venn$trans_comm()}}
\item \href{#method-print}{\code{trans_venn$print()}}
\item \href{#method-clone}{\code{trans_venn$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_venn$new(
  dataset = NULL,
  sample_names = NULL,
  ratio = NULL,
  add_abund_table = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataset}}{the object of \code{\link{microtable}} Class.}

\item{\code{sample_names}}{default NULL; if provided, filter the samples.}

\item{\code{ratio}}{default NULL; NULL, "numratio" or "seqratio"; numratio: calculate number percentage; seqratio: calculate sequence percentage; 
NULL: no additional percentage.}

\item{\code{add_abund_table}}{default NULL; data.frame or matrix format; additional data provided instead of dataset$otu_table;
Features must be rows.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
data_details and data_summary stored in trans_venn object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
data(dataset)
t1 <- dataset$merge_samples(use_group = "Group")
t1 <- trans_venn$new(dataset = t1, ratio = "numratio")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot_venn"></a>}}
\if{latex}{\out{\hypertarget{method-plot_venn}{}}}
\subsection{Method \code{plot_venn()}}{
Plot venn diagram.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_venn$plot_venn(
  color_circle = RColorBrewer::brewer.pal(8, "Dark2"),
  fill_color = TRUE,
  text_size = 4.5,
  text_name_size = 6,
  text_name_position = NULL,
  alpha = 0.3,
  linesize = 1.1,
  petal_plot = FALSE,
  petal_color = "#BEAED4",
  petal_color_center = "#BEBADA",
  petal_a = 4,
  petal_r = 1,
  petal_use_lim = c(-12, 12),
  petal_center_size = 40,
  petal_move_xy = 4,
  petal_move_k = 2.3,
  petal_move_k_count = 1.3,
  petal_text_move = 40,
  other_text_show = NULL,
  other_text_position = c(2, 2),
  other_text_size = 5
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{color_circle}}{default RColorBrewer::brewer.pal(8, "Dark2"); color pallete}

\item{\code{fill_color}}{default TRUE; whether fill the area color}

\item{\code{text_size}}{default 4.5; text size in plot}

\item{\code{text_name_size}}{default 6; name size in plot}

\item{\code{text_name_position}}{default NULL; name position in plot}

\item{\code{alpha}}{default .3; alpha for transparency}

\item{\code{linesize}}{default 1.1; cycle line size}

\item{\code{petal_plot}}{default FALSE; whether use petal plot.}

\item{\code{petal_color}}{default "#BEAED4"; color of the petals.}

\item{\code{petal_color_center}}{default "#BEBADA"; color of the center in the petal plot.}

\item{\code{petal_a}}{default 4; the length of the ellipse}

\item{\code{petal_r}}{default 1; scaling up the size of the ellipse}

\item{\code{petal_use_lim}}{default c(-12, 12); the width of the plot}

\item{\code{petal_center_size}}{default 40; petal center circle size}

\item{\code{petal_move_xy}}{default 4; the distance of text to circle}

\item{\code{petal_move_k}}{default 2.3; the distance of title to circle}

\item{\code{petal_move_k_count}}{default 1.3; the distance of data text to circle}

\item{\code{petal_text_move}}{default 40; the distance between two data text}

\item{\code{other_text_show}}{default NULL; other characters used to show in the plot}

\item{\code{other_text_position}}{default c(1, 1); the text position for text in other_text_show}

\item{\code{other_text_size}}{default 5; the text size for text in other_text_show}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$plot_venn()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_comm"></a>}}
\if{latex}{\out{\hypertarget{method-trans_comm}{}}}
\subsection{Method \code{trans_comm()}}{
Transform venn result to community-like microtable object for further composition analysis.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_venn$trans_comm(use_frequency = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use_frequency}}{default TRUE; whether only use OTUs occurrence frequency, i.e. presence/absence data; if FALSE, use abundance data.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a new \code{\link{microtable}} class.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t2 <- t1$trans_comm(use_frequency = TRUE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Print the trans_venn object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_venn$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_venn$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
