% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iterative_clustering.R
\name{iterative_clustering}
\alias{iterative_clustering}
\title{Iterative Hartigan-Wong k-means clustering.}
\usage{
iterative_clustering(data, parallel = TRUE)
}
\arguments{
\item{data}{input matrix with paired times, i.e. samples to be stressed to multiple iterations.}

\item{parallel}{logical; FALSE to sequentially run the internal loop or TRUE to do it by parallel computing (number of cores = 4).}
}
\value{
A list with multiple objects of class "kmeans".
}
\description{
Perform Hartigan-Wong \code{\link[stats:kmeans]{stats::kmeans()}} algorithm as many times as possible. The values of k are from 2 to the number of rows minus 1.
}
\examples{
t1_t2 <- paired_times(data = clr[,1:50], first = "_1",
                      second = "_25", common = "_0_")
klist_t1_t2 <- iterative_clustering(data = t1_t2, parallel = FALSE)
}
