% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flexCItest.R
\name{flexCItest}
\alias{flexCItest}
\title{Wrapper for gaussCItest, disCItest and mixCItest}
\usage{
flexCItest(x, y, S = NULL, suffStat)
}
\arguments{
\item{x, y, S}{(integer) position of variable X, Y and set of variables S,
respectively, in the dataset. It is tested whether X and Y are conditionally
independent given the subset S of the remaining variables.}

\item{suffStat}{a list generated using \code{getSuff()} with \code{test="flexMItest"}. See below for details.}
}
\value{
A p-value.
}
\description{
A plug-in conditional independence test for \code{\link[pcalg:skeleton]{pcalg::skeleton()}}, \code{\link[pcalg:pc]{pcalg::pc()}} or
\code{\link[pcalg:fci]{pcalg::fci()}} when multiply imputed data sets are available. \code{\link[=flexCItest]{flexCItest()}} detects whether
variables are continuous, discrete or mixed, and automatically switches between \code{\link[=gaussCItest]{gaussCItest()}} (continuous only),
\code{\link[=disCItest]{disCItest()}} (discrete only) and \code{\link[=mixCItest]{mixCItest()}} (mixed variables).
}
\details{
\code{suffStat} needs to be a list with four elements named \code{datlist}, \code{corlist},
\code{conpos} and \code{dispos}. \code{datlist} is the list of imputed datasets. \code{corlist}
is a list with M+1 elements, where M is the number of imputed datasets. For i=1,...,M, the
the i-th element of \code{corlist} is the correlation matrix of the continuous variables in the i-th imputed dataset;
the (M+1)-the element is the number of rows in each imputed dataset.
\code{conpos} is a vector containing the integer positions of the continuous variables in the original dataset.
\code{dispos} is a vector containing the integer positions of the discrete variables in the original dataset.
}
\examples{
# load data (numeric and factor variables)
dat <- toenail2[1:400, ]

# obtain correct input 'suffStat' for 'flexCItest'
suff <- getSuff(dat, test="flexCItest")

flexCItest(2,3,NULL, suffStat = suff)

}
\seealso{
\code{\link[=gaussCItest]{gaussCItest()}}, \code{\link[=disCItest]{disCItest()}} and \code{\link[=mixCItest]{mixCItest()}}.
}
