% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/animals_score.R
\name{calculate_score_animals}
\alias{calculate_score_animals}
\title{Calculate animal model scores for abstracts}
\usage{
calculate_score_animals(
  df,
  keywords = animal_keywords,
  case = FALSE,
  threshold = NULL,
  indicate = FALSE,
  discard = FALSE,
  col.abstract = Abstract
)
}
\arguments{
\item{df}{Data frame containing abstracts.}

\item{keywords}{Character vector. Vector containing keywords. The score is
calculated based on these keywords. How much weight a keyword in \code{keywords}
carries is determined by how often it is present in \code{keywords}, e.g. if
a keyword is mentioned twice in \code{keywords} and it is mentioned only once in
an abstract, it adds 2 points to the score.
The predefined keywords can be accessed via \code{miRetrieve::animal_keywords}.}

\item{case}{Boolean. If \code{case = TRUE}, terms contained in \code{keywords} are case
sensitive. If \code{case = FALSE}, terms contained in \code{keywords} are case insensitive.}

\item{threshold}{Integer. Optional. Threshold to decide if an abstract is
considered to use animal models or not. If \code{indicate = TRUE} or \code{discard = TRUE}
and \code{threshold} is not specified, \code{threshold} is automatically set to \code{1}.}

\item{indicate}{Boolean. If \code{indicate = TRUE}, an extra column is added. This
extra column contains "Yes" or "No", indicating the use of animal models
in abstracts.}

\item{discard}{Boolean. If \code{discard = TRUE}, only abstracts are kept where
animal models are present.}

\item{col.abstract}{Symbol. Column containing abstracts.}
}
\value{
Data frame with calculated animal model scores.
If \code{discard = FALSE}, adds extra columns
to the original data frame with the calculated animal model scores.
If \code{discard = TRUE}, only abstracts with animal models are kept.
}
\description{
Calculate animal model score for each abstract to indicate possible
use of animal models.
}
\details{
Calculate animal model score for each abstract to indicate possible
use of animal models. This score is added to the data frame as an additional
column \code{Animal_score}, containing the calculated animal model score.
To decide which abstracts are considered to contain animal models, a threshold
can be set via the \code{threshold} argument. Furthermore, an additional
column can be added, verbally indicating the use of animal models in
an abstract.
Choosing the right threshold can be facilitated using \code{plot_score_animals()}.
}
\seealso{
\code{\link[=plot_score_animals]{plot_score_animals()}}

Other score functions: 
\code{\link{assign_topic}()},
\code{\link{calculate_score_biomarker}()},
\code{\link{calculate_score_patients}()},
\code{\link{calculate_score_topic}()},
\code{\link{plot_score_animals}()},
\code{\link{plot_score_biomarker}()},
\code{\link{plot_score_patients}()},
\code{\link{plot_score_topic}()}
}
\concept{score functions}
