% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_mir.R
\name{subset_mir}
\alias{subset_mir}
\title{Subset data frame for specific miRNA names}
\usage{
subset_mir(df, mir.retain, col.mir = miRNA)
}
\arguments{
\item{df}{Data frame containing a miRNA names.}

\item{mir.retain}{Character vector. Vector specifying which miRNA names to keep.
miRNA names in \code{mir.retain} must match miRNA names in \code{col.mir} in \code{df}.}

\item{col.mir}{Symbol. Column containing miRNA names.}
}
\value{
Data frame containing only specified miRNA names.
If no miRNA name in \code{mir.retain} matches a miRNA name in \code{col.mir}, \code{subset_mir()} stops
with a warning saying \emph{"No miRNA name in 'mir.retain' matches a miRNA name in 'col.mir'.
Could not filter for miRNA name."}.
}
\description{
Subset data frame for specific miRNA names only.
}
\details{
Subset data frame for specific miRNA names only.
}
\seealso{
\code{\link[=get_mir]{get_mir()}}, \code{\link[=subset_mir_threshold]{subset_mir_threshold()}}

Other subset functions: 
\code{\link{subset_df}()},
\code{\link{subset_mir_threshold}()},
\code{\link{subset_research}()},
\code{\link{subset_review}()},
\code{\link{subset_snp}()},
\code{\link{subset_year}()}
}
\concept{subset functions}
