% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df_operations_combine_addtopic_subsetmir.R
\name{indicate_mir}
\alias{indicate_mir}
\title{Indicate if a miRNA name is contained in an abstract}
\usage{
indicate_mir(df, indicate.mir, col.mir = miRNA)
}
\arguments{
\item{df}{Data frame containing miRNA names.}

\item{indicate.mir}{Character vector. Vector containing miRNA names to indicate.}

\item{col.mir}{Symbol. Column containing miRNA names.}
}
\value{
Data frame with as many columns added as miRNA names given
in \code{indicate.mir}.
Per column, a "Yes" or "No" indicates if the miRNA name of interest
is present in the
corresponding abstract.
}
\description{
Indicate if a miRNA name is contained in an abstract with
"Yes"/"No".
}
\details{
Indicate if a miRNA name is contained in an abstract with "Yes"/"No".
This requires miRNA names already to be extracted, e.g. with \code{extract_mir_df()},
and to be stored in a separate column, specified by \code{col.mir}.
\code{indicate_mir()} adds another column to a data frame which bears the name
of the miRNA(s) of interest. Within this column, a "Yes" or "No" specifies
if this miRNA name is contained in the corresponding abstract.
}
\seealso{
\code{\link[=extract_mir_df]{extract_mir_df()}}, \code{\link[=indicate_term]{indicate_term()}}

Other indicate functions: 
\code{\link{indicate_term}()}
}
\concept{indicate functions}
