% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_mir_terms.R
\name{compare_mir_terms_log2}
\alias{compare_mir_terms_log2}
\title{Compare log2-frequency count of terms associated with a miRNA name}
\usage{
compare_mir_terms_log2(
  df,
  mir,
  top = 20,
  token = "words",
  ...,
  topic = NULL,
  shared = TRUE,
  normalize = TRUE,
  stopwords = stopwords_miretrieve,
  stopwords_ngram = TRUE,
  col.mir = miRNA,
  col.abstract = Abstract,
  col.topic = Topic,
  col.pmid = PMID,
  title = NULL
)
}
\arguments{
\item{df}{Data frame containing miRNA names, abstracts, topics, and PubMed-IDs.}

\item{mir}{String. miRNA name of interest.}

\item{top}{Integer. Number of top terms to plot.}

\item{token}{String. Specifies how abstracts shall be split up. Taken from
\code{unnest_tokens()} in the \pkg{tidytext} package:
"Unit for tokenizing, or a custom tokenizing function. Built-in options are
"words" (default), "characters", "character_shingles", "ngrams", "skip_ngrams",
"sentences", "lines", "paragraphs", "regex",
(...),
and "ptb" (Penn Treebank). If a function, should take a character vector and
return a list of character vectors of the same length."}

\item{...}{Additional arguments for tokenization, if necessary.}

\item{topic}{Character vector. Optional. Specifies which topics to plot.
Must have length two.
If \code{topic = NULL}, all topics in \code{df} are plotted.}

\item{shared}{Boolean. If \code{shared = TRUE}, only terms that are shared
between the two topics are plotted.}

\item{normalize}{Boolean. If \code{normalize = TRUE}, normalizes the number of
abstracts to the total number of abstracts in a topic.}

\item{stopwords}{Data frame containing stop words.}

\item{stopwords_ngram}{Boolean. Specifies if stop words shall be removed
from abstracts when using ngrams. Only applied when \code{token = 'ngrams'}.}

\item{col.mir}{Symbol. Column containing miRNA names.}

\item{col.abstract}{Symbol. Column containing abstracts.}

\item{col.topic}{Symbol. Column containing topic names.}

\item{col.pmid}{Symbol. Column containing PubMed-IDs.}

\item{title}{String. Plot title.}
}
\value{
List containing bar plot comparing the log2-frequency of terms associated with a
miRNA over two topics and its corresponding data frame.
}
\description{
Compare log2-frequency count of terms associated with a miRNA name
over two topics.
}
\details{
Compare log2-frequency count of terms associated with a miRNA name over two topics by
plotting the log2-ratio of the term count associated with a miRNA name
over two topics.
miRNA names and topics must be in a data frame \code{df}, while terms are taken
from abstracts contained in \code{df}.
Number of top terms to plot is regulated by \code{top}. Terms can either be
evaluated as their raw count, e.g. in how many abstracts they are mentioned
in conjunction with the miRNA name, or as their relative count, e.g.
in how many abstracts containing the miRNA they are mentioned compared to all
abstracts containing the miRNA.
\code{compare_mir_terms_log2()} is based on the tools available in the
\pkg{tidytext} package.
The log2-plot is greatly inspired by the book
“tidytext: Text Mining and Analysis Using Tidy Data Principles in R.” by
Silge and Robinson.
}
\references{
Silge, Julia, and David Robinson. 2016.
“tidytext: Text Mining and Analysis Using Tidy Data Principles in R.”
JOSS 1 (3). The Open Journal. https://doi.org/10.21105/joss.00037.
}
\seealso{
\code{\link[=compare_mir_terms]{compare_mir_terms()}}, \code{\link[=compare_mir_terms_scatter]{compare_mir_terms_scatter()}}

Other compare functions: 
\code{\link{compare_mir_count_log2}()},
\code{\link{compare_mir_count_unique}()},
\code{\link{compare_mir_count}()},
\code{\link{compare_mir_terms_scatter}()},
\code{\link{compare_mir_terms_unique}()},
\code{\link{compare_mir_terms}()}
}
\concept{compare functions}
