% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datadocs.R
\docType{data}
\name{bladder}
\alias{bladder}
\title{Bladder tumor recurrence data.}
\format{
A data frame with 86 rows and 13 variables:
\describe{
\item{Group:}{Placebo vs treatment (thiotepa).}
\item{Number:}{Number of tumors present at baseline, with 8 denoting 8
or more.}
\item{Size:}{Size of largest tumor at baseline, in centimeters.}
\item{CensorTime:}{Censor time, in months.}
\item{T1:}{For i = 1,...,9, T_i is the recurrence time, in months.
If there is no recurrence, T_1, ..., T_9 will be NA. If there is only one,
T_1 will be filled and T_2, ..., T_9 will be NA, and so on.}
\item{T2:}{See T1.}
\item{T3:}{See T1.}
\item{T4:}{See T1.}
\item{T5:}{See T1.}
\item{T6:}{See T1.}
\item{T7:}{See T1.}
\item{T8:}{See T1.}
\item{T9:}{See T1.}
}
}
\source{
Table 1.2, page 18 of Prentice and Zhao 2019, taken from
Table 9.2 on page 292 in The Statistical Analysis of Failure Time Data,
Second Edition, by J. D. Kalbfleisch and R. L. Prentice. New York: Wiley
and Sons, 2002.
}
\usage{
data(bladder)
}
\description{
Data from a randomized trial of patient recurrences of superficial
bladder tumor recurrence as conducted by the Veterans Administration
Cooperative Urological Group. These data were used to compare the
frequency of recurrences among 48 patients assigned to placebo, among
whom there were a total of 87 post-randomization recurrences, and 38
patients assigned to treatment with a drug called thiotepa, among whom
there were 45 recurrences during the follow-up period, which averaged
about 31 months.
}
\references{
Prentice, R., Zhao, S. "The statistical analysis of multivariate
failure time data: A marginal modeling approach", CRC Press (2019).
}
\keyword{datasets}
